define('bitbucket/internal/enums', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    /**
     * A user type
     * @enum {string}
     */
    var UserType = exports.UserType = {
        NORMAL: 'NORMAL',
        SERVICE: 'SERVICE'
    };

    /**
     * A project type
     * @enum {string}
     */
    var ProjectType = exports.ProjectType = {
        NORMAL: 'NORMAL',
        PERSONAL: 'PERSONAL'
    };

    /**
     * The SCM id
     * @enum {string}
     */
    var scmId = exports.scmId = {
        GIT: 'git',
        HG: 'hg'
    };

    /**
     * The type of a ref
     * @enum {string}
     */
    var RefType = exports.RefType = {
        TAG: 'tag',
        BRANCH: 'branch',
        COMMIT: 'commit'
    };

    /**
     * Pull request participant's role
     * @enum {string}
     */
    var ParticipantRole = exports.ParticipantRole = {
        AUTHOR: 'author',
        REVIEWER: 'reviewer',
        PARTICIPANT: 'participant'
    };

    var UserRole = exports.UserRole = ParticipantRole;

    /**
     * Pull request Participant's approval state of the pull request
     * @enum {string}
     */
    var ApprovalStatus = exports.ApprovalStatus = {
        APPROVED: 'APPROVED',
        NEEDS_WORK: 'NEEDS_WORK',
        UNAPPROVED: 'UNAPPROVED'
    };

    /**
     * User's actions to add/remove themselves from a PR
     * @enum {string}
     */
    var SelfAction = exports.SelfAction = {
        ADD_SELF: 'ADD_SELF',
        REMOVE_SELF: 'REMOVE_SELF'
    };

    /**
     * Pull request state
     * @enum {string}
     */
    var PullRequestState = exports.PullRequestState = {
        OPEN: 'OPEN',
        MERGED: 'MERGED',
        DECLINED: 'DECLINED'
    };

    var BranchStability = exports.BranchStability = {
        STABLE: 'stable',
        UNSTABLE: 'unstable'
    };

    var MergeOutcome = exports.MergeOutcome = {
        CLEAN: 'CLEAN',
        CONFLICTED: 'CONFLICTED',
        UNKNOWN: 'UNKNOWN'
    };

    exports.default = {
        ApprovalStatus: ApprovalStatus,
        BranchStability: BranchStability,
        ProjectType: ProjectType,
        PullRequestState: PullRequestState,
        RefType: RefType,
        ParticipantRole: ParticipantRole,
        SelfAction: SelfAction,
        scmId: scmId,
        UserRole: ParticipantRole,
        UserType: UserType
    };
});