/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.instance.DefaultNodeExtension;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.MemberSocketInterceptor;

public class ExtendedNodeExtension
extends DefaultNodeExtension {
    private MemberSocketInterceptor memberSocketInterceptor;

    public ExtendedNodeExtension(Node node) {
        super(node);
    }

    public void beforeStart() {
        super.beforeStart();
        SocketInterceptorConfig config = this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
        if (config != null && config.isEnabled()) {
            this.memberSocketInterceptor = this.createInterceptor(config, this.node.getConfigClassLoader(), this.node.hazelcastInstance.managedContext);
        }
    }

    public MemberSocketInterceptor getMemberSocketInterceptor() {
        return this.memberSocketInterceptor;
    }

    private MemberSocketInterceptor createInterceptor(SocketInterceptorConfig config, ClassLoader classLoader, ManagedContext managedContext) {
        MemberSocketInterceptor interceptor = (MemberSocketInterceptor)config.getImplementation();
        if (interceptor != null) {
            return interceptor;
        }
        try {
            interceptor = (MemberSocketInterceptor)ClassLoaderUtil.newInstance((ClassLoader)classLoader, (String)config.getClassName());
            interceptor.init(config.getProperties());
            if (managedContext != null) {
                interceptor = (MemberSocketInterceptor)managedContext.initialize((Object)interceptor);
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to instantiate MemberSocketInterceptor", (Throwable)e);
        }
        return interceptor;
    }
}

