/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.web;

import com.atlassian.stash.internal.web.util.web.CountingServletInputStream;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CountingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final Supplier<CountingServletInputStream> in = Suppliers.memoize(() -> {
        try {
            this.opened = true;
            return new CountingServletInputStream(request.getInputStream());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    });
    private final Supplier<BufferedReader> reader = Suppliers.memoize(() -> {
        try {
            if (request.getCharacterEncoding() != null) {
                return new BufferedReader(new InputStreamReader((InputStream)this.in.get(), request.getCharacterEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate((Throwable)e);
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.in.get()));
    });
    private boolean opened;

    public CountingHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        return (ServletInputStream)this.in.get();
    }

    public BufferedReader getReader() throws IOException {
        return (BufferedReader)this.reader.get();
    }

    public long getBytesRead() {
        return this.opened ? ((CountingServletInputStream)this.in.get()).getBytesRead() : 0L;
    }
}

