/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.captcha;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
final class Levenshtein {
    private Levenshtein() {
    }

    @Nonnull
    static Set<String> nearbyWords(@Nonnull String word, @Nonnull CharSequence alphabet) {
        Objects.requireNonNull(word, "word");
        Objects.requireNonNull(alphabet, "alphabet");
        HashSet<String> nearbySet = new HashSet<String>();
        Levenshtein.oneCharSubstitutions((String)word, (CharSequence)alphabet, nearbySet);
        Levenshtein.oneCharDeletions((String)word, nearbySet);
        Levenshtein.oneCharAdditions((String)word, (CharSequence)alphabet, nearbySet);
        return nearbySet;
    }

    private static void oneCharAdditions(String seedWord, CharSequence alphabet, Set<String> bucket) {
        for (int i = 0; i <= seedWord.length(); ++i) {
            String prefix = seedWord.substring(0, i);
            String postfix = seedWord.substring(i);
            Levenshtein.sandwichAlphas((String)prefix, (String)postfix, (CharSequence)alphabet, bucket);
        }
    }

    private static void oneCharDeletions(String seedWord, Set<String> bucket) {
        for (int i = 0; i < seedWord.length(); ++i) {
            String prefix = seedWord.substring(0, i);
            String postfix = seedWord.substring(i + 1);
            bucket.add(prefix + postfix);
        }
    }

    private static void oneCharSubstitutions(String seedWord, CharSequence alphabet, Set<String> bucket) {
        for (int i = 0; i < seedWord.length(); ++i) {
            String prefix = seedWord.substring(0, i);
            String postfix = seedWord.substring(i + 1);
            Levenshtein.sandwichAlphas((String)prefix, (String)postfix, (CharSequence)alphabet, bucket);
        }
    }

    private static void sandwichAlphas(String prefix, String postfix, CharSequence alphabet, Set<String> bucket) {
        for (int j = 0; j < alphabet.length(); ++j) {
            bucket.add(prefix + alphabet.charAt(j) + postfix);
        }
    }
}

