/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.http.mime.ContentDispositionHeaderGuesser;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DownloadHeaderHelper {
    private static final String FILENAME_HEADER = "; filename=";
    private static final String UTF8_FILENAME_HEADER = "; filename*=UTF-8''";
    private final ContentDispositionHeaderGuesser contentDispositionGuesser;

    @Autowired
    public DownloadHeaderHelper(ContentDispositionHeaderGuesser contentDispositionGuesser) {
        this.contentDispositionGuesser = contentDispositionGuesser;
    }

    public void setDownloadHeaders(HttpServletResponse response, String path, String fileContentType, String userAgent) {
        String contentDisposition = this.contentDispositionGuesser.guessContentDispositionHeader(path, fileContentType, userAgent);
        String contentType = this.contentDispositionGuesser.guessMIME(path, fileContentType, userAgent);
        if (StringUtils.startsWith((CharSequence)contentType, (CharSequence)"text/")) {
            contentType = contentType + ";charset=UTF-8";
        }
        if ("attachment".equals(contentDisposition)) {
            response.setHeader("X-Download-Options", "noopen");
        }
        String filename = path.contains("/") ? StringUtils.substringAfterLast((String)path, (String)"/") : path;
        response.setHeader("Content-Disposition", contentDisposition + FILENAME_HEADER + "\"" + filename + "\"" + UTF8_FILENAME_HEADER + UrlUtils.encodeURL((String)filename));
        response.setContentType(contentType);
    }
}

