/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.timezone;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.timezone.TimeZoneService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.web.timezone.AbstractTimeZoneFormFragment;
import com.atlassian.stash.internal.web.timezone.LocalizedZoneCollection;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServerTimeZoneFormFragment
extends AbstractTimeZoneFormFragment {
    private final I18nService i18nService;
    private final InternalLocaleService localeService;
    private final TimeZoneService timeZoneService;

    ServerTimeZoneFormFragment(@Nonnull I18nService i18nService, @Nonnull InternalLocaleService localeService, @Nonnull SoyTemplateRenderer soyTemplateRenderer, @Nonnull TimeZoneService timeZoneService) {
        super(i18nService, localeService, soyTemplateRenderer);
        this.i18nService = i18nService;
        this.localeService = localeService;
        this.timeZoneService = timeZoneService;
    }

    void execute(@Nullable ZoneId zoneId) {
        this.timeZoneService.setServerTimeZone(zoneId);
    }

    @Nonnull
    Optional<ZoneId> getCurrent() {
        return this.timeZoneService.getServerTimeZone();
    }

    @Nonnull
    LocalizedZoneCollection.LocalizedTimeZone getDefaultTimeZone() {
        return LocalizedZoneCollection.timeZone((ZoneId)this.timeZoneService.getJvmTimeZone(), (Locale)this.localeService.getLocale(), (String)this.i18nService.getMessage("bitbucket.web.timezone.default.time.zone", new Object[0]), (String)"");
    }

    @Nonnull
    String getDescription() {
        return this.i18nService.getMessage("bitbucket.web.timezone.description", new Object[0]);
    }

    boolean isLongField() {
        return true;
    }
}

