/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.timezone;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.util.RequestUtils;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.web.timezone.LocalizedZoneCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class AbstractTimeZoneFormFragment
implements ContextualFormFragment {
    private static final String FIELD_ZONE = "timezone";
    private static final String PARAM_DEFAULT_OPTION = "defaultOption";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_IS_LONG = "isLong";
    private static final String PARAM_ERRORS = "errors";
    private static final String PARAM_REGIONS = "regions";
    private static final String PARAM_SELECTED = "selected";
    private static final String TIMEZONE_TEMPLATE = "bitbucket.internal.feature.timezone.timeZoneField";
    private final I18nService i18nService;
    private final InternalLocaleService localeService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    AbstractTimeZoneFormFragment(@Nonnull I18nService i18nService, @Nonnull InternalLocaleService localeService, @Nonnull SoyTemplateRenderer soyTemplateRenderer) {
        this.i18nService = i18nService;
        this.localeService = localeService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void doError(Appendable appendable, Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors, Map<String, Object> context) throws IOException {
        Collection errors = fieldErrors.getOrDefault("timezone", Collections.emptyList());
        this.render(appendable, AbstractTimeZoneFormFragment.getRawZoneId(requestParams), errors);
    }

    public void doView(Appendable appendable, Map<String, Object> context) throws IOException {
        this.render(appendable, (String)this.getCurrent().map(ZoneId::getId).orElse(null), Collections.emptyList());
    }

    public void execute(Map<String, String[]> requestParams, Map<String, Object> context) {
        this.execute(AbstractTimeZoneFormFragment.getZoneId(requestParams));
    }

    public void validate(Map<String, String[]> requestParams, ValidationErrors errors, Map<String, Object> context) {
        try {
            AbstractTimeZoneFormFragment.getZoneId(requestParams);
        }
        catch (DateTimeException e) {
            errors.addFieldError("timezone", this.i18nService.getMessage("bitbucket.web.timezone.invalid", new Object[0]));
        }
    }

    abstract void execute(@Nullable ZoneId var1);

    @Nonnull
    abstract Optional<ZoneId> getCurrent();

    @Nonnull
    abstract LocalizedZoneCollection.LocalizedTimeZone getDefaultTimeZone();

    @Nonnull
    abstract String getDescription();

    abstract boolean isLongField();

    private void render(Appendable appendable, String timeZone, Collection<String> errors) {
        try {
            ImmutableMap templateParams = ImmutableMap.builder().put((Object)"defaultOption", (Object)this.getDefaultTimeZone()).put((Object)"description", (Object)this.getDescription()).put((Object)"isLong", (Object)this.isLongField()).put((Object)"regions", (Object)new LocalizedZoneCollection(this.localeService.getLocale()).getRegions()).put((Object)"selected", (Object)(timeZone == null ? "" : timeZone)).put((Object)"errors", (Object)ImmutableList.copyOf(errors)).build();
            this.soyTemplateRenderer.render(appendable, "com.atlassian.bitbucket.server.bitbucket-web:server-soy-templates", "bitbucket.internal.feature.timezone.timeZoneField", (Map)templateParams);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render bitbucket.internal.feature.timezone.timeZoneField", (Throwable)e);
        }
    }

    private static String getRawZoneId(Map<String, String[]> requestParams) {
        return StringUtils.stripToNull((String)RequestUtils.getParamValue((String)"timezone", requestParams));
    }

    private static ZoneId getZoneId(Map<String, String[]> requestParams) {
        String id = AbstractTimeZoneFormFragment.getRawZoneId(requestParams);
        return id == null ? null : ZoneId.of(id);
    }
}

