/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions.nav;

import com.atlassian.stash.internal.web.soy.functions.nav.NavOptionsUtils;
import com.google.common.base.Preconditions;
import java.util.Map;

class NavOptionsUtils {
    NavOptionsUtils() {
    }

    static String withNavOptions(NavOptionsCallback callback, Object[] soyArgs) {
        String urlMode;
        Object maybeMap;
        Map options = null;
        if (soyArgs.length > 0 && (maybeMap = soyArgs[soyArgs.length - 1]) instanceof Map) {
            options = (Map)maybeMap;
        }
        if (options == null) {
            return callback.buildRelative();
        }
        Map queryParams = (Map)options.get("queryParams");
        if (queryParams != null) {
            for (Map.Entry entry : queryParams.entrySet()) {
                Preconditions.checkArgument((boolean)(entry.getKey() instanceof String), (Object)String.format("Parameter map must use all string keys (found %s)", entry.getKey().getClass().getSimpleName()));
                Preconditions.checkArgument((boolean)(entry.getValue() instanceof String), (Object)String.format("Parameter map must use all string values (found %s)", entry.getValue().getClass().getSimpleName()));
                callback.withQueryParam((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ("configured".equalsIgnoreCase(urlMode = (String)options.get("urlMode"))) {
            return callback.buildConfigured();
        }
        if ("absolute".equalsIgnoreCase(urlMode)) {
            return callback.buildAbsolute();
        }
        return callback.buildRelative();
    }
}

