/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.SanitizedString;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.fragments.WebFragmentSupport;
import com.atlassian.stash.internal.web.fragments.WebPanelData;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import java.util.Set;

public class WebPanelSelectionFunction
implements SoyServerFunction<SanitizedString> {
    private static final Set<Integer> VALID_ARG_SIZE = SoyArgumentUtils.argCountOf((int)2);
    private final WebFragmentSupport webFragmentSupport;

    public WebPanelSelectionFunction(WebFragmentSupport webFragmentSupport) {
        this.webFragmentSupport = webFragmentSupport;
    }

    public String getName() {
        return "getWebPanel";
    }

    public SanitizedString apply(Object ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZE.contains(args.length), (Object)("invalid number of arguments: " + args.length));
        String location = (String)args[0];
        String panelKey = (String)args[1];
        return this.webFragmentSupport.getWebPanels(location, null, true).stream().filter(panel -> panelKey.equals(panel.getKey())).map(WebPanelData::getHtml).map(SanitizedString::new).findFirst().orElse(null);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZE;
    }
}

