/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.bitbucket.util.Weighted;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.fragments.WebFragmentData;
import com.atlassian.stash.internal.web.fragments.WebFragmentSupport;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.fragments.WebPanelData;
import com.atlassian.stash.internal.web.fragments.WebSectionData;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDeprecatedServerFragmentFunction
implements SoyServerFunction<List<WebFragmentData>> {
    private static final Logger log = LoggerFactory.getLogger(GetDeprecatedServerFragmentFunction.class);
    private static final String CORE_FRAGMENTS_PLUGIN_KEY = "com.atlassian.bitbucket.server.bitbucket-server-web-fragments";
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)3, (int)4);
    private final boolean isDevMode;
    private final WebFragmentSupport webFragmentSupport;

    public GetDeprecatedServerFragmentFunction(WebFragmentSupport webFragmentSupport) {
        this.webFragmentSupport = webFragmentSupport;
        this.isDevMode = DevModeUtils.isEnabled();
    }

    public String getName() {
        return "getDeprecatedServerFragments";
    }

    public List<WebFragmentData> apply(Object ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (Object[])new Object[]{args.length});
        int argOffset = 0;
        List parentFragments = null;
        if (args.length == 4) {
            parentFragments = (List)SoyArgumentUtils.checkType((Object[])args, List.class, (int)0, (String)"When using the 4-arg method, the first arg must be a list of parent fragments.");
            ++argOffset;
        }
        String location = (String)SoyArgumentUtils.checkType((Object[])args, String.class, (int)argOffset, (String)"location must be a string.");
        Set types = this.typesFromStrings((Collection)SoyArgumentUtils.checkType((Object[])args, List.class, (int)(1 + argOffset), (String)"types must be a list of strings like ['ITEM', 'SECTION', 'PANEL']."));
        Map context = (Map)SoyArgumentUtils.checkType((Object[])args, Map.class, (int)(2 + argOffset), (String)"context must be a map of strings to objects.");
        if (parentFragments == null) {
            return this.getFragments(location, types, context);
        }
        ArrayList<WebFragmentData> fragments = new ArrayList<WebFragmentData>();
        for (WebFragmentData parent : parentFragments) {
            List childFragments = this.getFragments(this.webFragmentSupport.formatLocation(location, parent), types, context);
            for (WebFragmentData child : childFragments) {
                child.setParent(parent);
            }
            fragments.addAll(childFragments);
        }
        return fragments;
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }

    private List<WebFragmentData> getFragments(String location, Set<WebFragmentData.Type> types, Map<String, Object> context) {
        List panels;
        List sections;
        List items = types.contains(WebFragmentData.Type.ITEM) ? this.webFragmentSupport.getWebItems(location, context, true) : Collections.emptyList();
        List webFragments = this.combineByWeight(items, sections = types.contains(WebFragmentData.Type.SECTION) ? this.webFragmentSupport.getWebSections(location, context, true) : Collections.emptyList(), panels = types.contains(WebFragmentData.Type.PANEL) ? this.webFragmentSupport.getWebPanels(location, context, true) : Collections.emptyList());
        boolean anyThirdParty = webFragments.stream().anyMatch(wf -> !CORE_FRAGMENTS_PLUGIN_KEY.equals(wf.getPluginKey()));
        if (anyThirdParty && this.isDevMode) {
            log.warn("The server-side web-fragment location '{}' is deprecated and will be removed in a future release.", (Object)location);
        }
        return webFragments;
    }

    private Set<WebFragmentData.Type> typesFromStrings(Collection<String> typeStrings) {
        return typeStrings.stream().map(WebFragmentData.Type::valueOf).collect(Collectors.toSet());
    }

    private List<WebFragmentData> combineByWeight(List<WebItemData> items, List<WebSectionData> sections, List<WebPanelData> panels) {
        ArrayList<WebFragmentData> fragments = new ArrayList<WebFragmentData>(items.size() + sections.size() + panels.size());
        fragments.addAll(items);
        fragments.addAll(sections);
        fragments.addAll(panels);
        Collections.sort(fragments, Weighted.COMPARABLE);
        return fragments;
    }
}

