/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import java.util.Set;

public class CliCommandEscapeFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountOf((int)1);

    public String getName() {
        return "escape_cli";
    }

    public String apply(Object ... args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Wrong number of arguments (1 expected)");
        Preconditions.checkArgument((boolean)(args[0] instanceof String), (Object)"The first argument, the cli command to escape, should be a string");
        String command = (String)args[0];
        return command.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public JsExpression generate(JsExpression ... jsArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append(jsArgs[0].getText()).append(".replace('\\\\', '\\\\\\\\').replace('\"', '\\\\\"')");
        return new JsExpression(sb.toString());
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

