/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos.jobs;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.repos.jobs.RestRescopeRequest;
import com.atlassian.stash.internal.web.repos.jobs.RestRescopeResult;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/jobs"})
public class RepositoryJobController
extends RepositoryControllerSupport {
    private final InternalPullRequestRescopeService pullRequestRescopeService;

    @Autowired
    public RepositoryJobController(I18nService i18nService, RefService refService, PermissionService permissionService, InternalProjectService projectService, RepositoryService repositoryService, InternalScmService scmService, InternalPullRequestRescopeService pullRequestRescopeService) {
        super(i18nService, refService, permissionService, projectService, repositoryService, scmService);
        this.pullRequestRescopeService = pullRequestRescopeService;
    }

    @IgnoresXsrf
    @RequestMapping(value={"/rescope-pull-requests"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<RestRescopeResult> rescopePullRequests(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="triggerOnly", defaultValue="false") boolean triggerOnly, @RequestBody RestRescopeRequest rescopeRequest) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        RepositoryRescopeResult result = triggerOnly ? this.pullRequestRescopeService.rescope(repository) : this.pullRequestRescopeService.rescope(repository, rescopeRequest.getBranches());
        RestRescopeResult restResult = new RestRescopeResult(result.getSkippedCount(), result.getErrorCount());
        HttpStatus status = result.hasErrors() ? HttpStatus.INTERNAL_SERVER_ERROR : HttpStatus.OK;
        return new ResponseEntity((Object)restResult, status);
    }
}

