/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.pull;

import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import org.apache.commons.lang3.StringUtils;

public class PullRequestForm {
    private int fromRepoId;
    private String fromBranch;
    private String toBranch;
    private String title;
    private String description;
    private String reviewers;

    public PullRequestForm() {
    }

    public PullRequestForm(int fromRepoId, String fromBranch, String toBranch, String title, String description, String reviewers) {
        this.fromRepoId = fromRepoId;
        this.fromBranch = fromBranch;
        this.toBranch = toBranch;
        this.title = title;
        this.description = description;
        this.reviewers = reviewers;
    }

    public int getFromRepoId() {
        return this.fromRepoId;
    }

    @RequiredString(size=1000)
    public String getFromBranch() {
        return this.fromBranch;
    }

    @RequiredString(size=1000)
    public String getToBranch() {
        return this.toBranch;
    }

    @RequiredString
    public String getTitle() {
        return this.title;
    }

    @OptionalString(size=1000)
    public String getReviewers() {
        return StringUtils.trimToNull((String)this.reviewers);
    }

    @OptionalString(size=32768)
    public String getDescription() {
        return StringUtils.trimToNull((String)this.description);
    }

    public void setFromRepoId(int fromRepoId) {
        this.fromRepoId = fromRepoId;
    }

    public void setFromBranch(String fromBranch) {
        this.fromBranch = fromBranch;
    }

    public void setToBranch(String toBranch) {
        this.toBranch = toBranch;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setReviewers(String reviewers) {
        this.reviewers = reviewers;
    }
}

