/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.maintenance;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.atlassian.soy.springmvc.SoyView;
import com.atlassian.stash.internal.maintenance.IncorrectTokenMaintenanceException;
import com.atlassian.stash.internal.maintenance.MaintenanceLock;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.rest.RestMaintenanceLock;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.maintenance.MaintenanceController;
import com.atlassian.stash.internal.web.maintenance.RestErrorTexts;
import com.atlassian.stash.internal.web.maintenance.RestMaintenanceStatus;
import com.atlassian.stash.internal.web.soy.MaintenanceInjectedDataFactory;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/maintenance"})
public class MaintenanceController
extends ControllerSupport {
    public static final String PATH_MAINTENANCE = "/maintenance";
    public static final String PATH_LOCK = "lock";
    public static final String VIEW_DB_REDIRECT = "redirect:/admin/db";
    public static final String VIEW_HOME_REDIRECT = "redirect:/";
    public static final String VIEW_MAINTENANCE_BACKUP = "bitbucket.internal.maintenance.backup";
    public static final String VIEW_MAINTENANCE_MIGRATION = "bitbucket.internal.maintenance.migration";
    private final InjectedDataFactory injectedDataFactory;
    private final MaintenanceService maintenanceService;
    private final RequestManager requestManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private long cancelTimeout;

    @Autowired
    public MaintenanceController(I18nService i18nService, MaintenanceService maintenanceService, RequestManager requestManager, SoyTemplateRenderer soyTemplateRenderer) {
        super(i18nService);
        this.maintenanceService = maintenanceService;
        this.requestManager = requestManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.injectedDataFactory = new MaintenanceInjectedDataFactory();
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ModelAndView cancelMaintenance(@RequestParam(value="token", required=false) String token, RedirectAttributes redirectAttributes) {
        MaintenanceTaskMonitor runningTask = this.maintenanceService.getRunningTask();
        if (runningTask == null) {
            return new ModelAndView("redirect:/");
        }
        try {
            redirectAttributes.addFlashAttribute("cancelMigrationSuccessful", (Object)runningTask.cancel(token, this.cancelTimeout, TimeUnit.MINUTES));
            return new ModelAndView(MaintenanceController.chooseRedirect((MaintenanceType)runningTask.getType()));
        }
        catch (IncorrectTokenMaintenanceException e) {
            return this.viewMaintenance(runningTask, (List)ImmutableList.of((Object)e.getLocalizedMessage()));
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, params={"token"}, value={"lock"})
    public ResponseEntity<RestErrorTexts> unlock(@RequestParam(value="token") String token) {
        MaintenanceLock lock = this.maintenanceService.getLock();
        if (lock == null) {
            return MaintenanceController.newResponse((HttpStatus)HttpStatus.NOT_FOUND);
        }
        try {
            lock.unlock(token);
            return MaintenanceController.newResponse((HttpStatus)HttpStatus.OK);
        }
        catch (IncorrectTokenMaintenanceException e) {
            return MaintenanceController.newResponse((HttpStatus)HttpStatus.CONFLICT, (Object)new RestErrorTexts(new String[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"lock"})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ModelAndView viewLock() {
        MaintenanceLock lock = this.maintenanceService.getLock();
        if (lock == null) {
            return new ModelAndView("redirect:/");
        }
        MaintenanceTaskMonitor taskStatus = this.maintenanceService.getRunningTask();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (taskStatus != null) {
            builder.put((Object)"status", (Object)taskStatus);
        }
        return this.modelAndView("bitbucket.internal.maintenance.lock", (Map)builder.build());
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ModelAndView viewMaintenance() {
        MaintenanceTaskMonitor task = this.maintenanceService.getRunningTask();
        if (task == null) {
            return new ModelAndView("redirect:/");
        }
        return this.viewMaintenance(task, null);
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, params={"token"}, produces={"application/json"}, consumes={"!application/x-www-form-urlencoded"})
    public ResponseEntity<RestMaintenanceStatus> cancelMaintenance(@RequestParam(value="token", required=true) String token) {
        MaintenanceTaskMonitor runningTask = this.maintenanceService.getRunningTask();
        if (runningTask == null) {
            return MaintenanceController.newResponse((HttpStatus)HttpStatus.NOT_FOUND);
        }
        try {
            runningTask.cancel(token, this.cancelTimeout, TimeUnit.MINUTES);
            return MaintenanceController.newResponse((HttpStatus)HttpStatus.ACCEPTED, (Object)new RestMaintenanceStatus(this.maintenanceService.getStatus()));
        }
        catch (IncorrectTokenMaintenanceException e) {
            return MaintenanceController.newResponse((HttpStatus)HttpStatus.CONFLICT, (Object)new RestMaintenanceStatus(this.maintenanceService.getStatus()));
        }
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"}, value={"lock"})
    public ResponseEntity<RestMaintenanceLock> lock() {
        MaintenanceLock context = this.maintenanceService.lock();
        return MaintenanceController.newResponse((HttpStatus)HttpStatus.ACCEPTED, (Object)new RestMaintenanceLock(context, true));
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"lock"})
    public ResponseEntity<RestMaintenanceLock> viewLockStatus() {
        MaintenanceLock lock = this.maintenanceService.getLock();
        if (lock == null) {
            return MaintenanceController.newResponse((HttpStatus)HttpStatus.NOT_FOUND);
        }
        return MaintenanceController.newResponse((HttpStatus)HttpStatus.OK, (Object)new RestMaintenanceLock(lock, false));
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<RestMaintenanceStatus> viewMaintenanceStatus() {
        return MaintenanceController.newResponse((HttpStatus)HttpStatus.OK, (Object)new RestMaintenanceStatus(this.maintenanceService.getStatus()));
    }

    @Value(value="${maintenance.cancel.timeout}")
    void setCancelTimeout(long cancelTimeout) {
        if (cancelTimeout < 1L) {
            this.log.warn("The configured cancel timeout, [{}] minutes, is too short and will be ignored. It will be defaulted to 1 minute", (Object)cancelTimeout);
            cancelTimeout = 1L;
        }
        this.cancelTimeout = cancelTimeout;
    }

    private ModelAndView modelAndView(String viewName, Map<String, Object> data) {
        return new ModelAndView((View)new SoyView(viewName, this.soyTemplateRenderer, this.injectedDataFactory, "com.atlassian.bitbucket.server.bitbucket-web:server-soy-templates"), data);
    }

    private ModelAndView viewMaintenance(MaintenanceTaskMonitor runningTask, List<String> errors) {
        RequestContext requestContext = this.requestManager.getRequestContext();
        HashMap data = Maps.newHashMap();
        if (requestContext != null && runningTask.isOwner(requestContext)) {
            data.put("cancelToken", runningTask.getCancelToken());
        }
        if (CollectionUtils.isNotEmpty(errors)) {
            data.put("errorTexts", errors);
        }
        data.put("status", runningTask.getProgress());
        return this.modelAndView(MaintenanceController.chooseView((MaintenanceType)runningTask.getType()), (Map)data);
    }

    private static <T> ResponseEntity<T> newResponse(HttpStatus status) {
        return MaintenanceController.newResponse((HttpStatus)status, null);
    }

    private static <T> ResponseEntity<T> newResponse(HttpStatus status, T result) {
        return new ResponseEntity(result, (MultiValueMap)MaintenanceController.noCache(), status);
    }

    private static HttpHeaders noCache() {
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl("no-cache");
        return headers;
    }

    private static String chooseRedirect(MaintenanceType type) {
        switch (1.$SwitchMap$com$atlassian$stash$internal$maintenance$MaintenanceType[type.ordinal()]) {
            case 1: {
                return "redirect:/admin/db";
            }
        }
        return "redirect:/";
    }

    private static String chooseView(MaintenanceType type) {
        switch (1.$SwitchMap$com$atlassian$stash$internal$maintenance$MaintenanceType[type.ordinal()]) {
            case 2: {
                return "bitbucket.internal.maintenance.backup";
            }
            case 1: {
                return "bitbucket.internal.maintenance.migration";
            }
        }
        throw new IllegalArgumentException(type + " maintenance is not supported");
    }
}

