/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="standardResponseHeadersFilter")
public class StandardResponseHeadersFilter
extends OncePerRequestFilter {
    static final String X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options".toLowerCase();
    static final String X_FRAME_OPTIONS = "X-Frame-Options".toLowerCase();
    static final String X_FRAME_OPTIONS_PLUGINS_SERVLET_PATH_PROPERTY = "plugins.servlet.std.headers.x-frame-options.path.patterns";
    static final String X_XSS_PROTECTION = "X-XSS-Protection".toLowerCase();
    private static final String LOGIN_PATH = "/mvc/login";
    private static final String PLUGINS_SERVLET_PATH_PREFIX = "/plugins/servlet/";
    private static final Logger log = LoggerFactory.getLogger(StandardResponseHeadersFilter.class);
    private final Map<String, Iterable<BiFunction<HttpServletRequest, String, Boolean>>> exemptListByHeader;
    private final Map<String, Iterable<BiFunction<HttpServletRequest, String, Boolean>>> mandatoryListByHeader;
    private final List<BiFunction<HttpServletRequest, String, Boolean>> pluginsServletPatternMatchers;

    public StandardResponseHeadersFilter(@Nonnull InternalApplicationPropertiesService propertiesService) {
        Objects.requireNonNull(propertiesService, "propertiesService");
        this.exemptListByHeader = ImmutableMap.of((Object)X_FRAME_OPTIONS, (Object)ImmutableList.of((request, path) -> path.startsWith(PLUGINS_SERVLET_PATH_PREFIX), (request, path) -> {
            String embedded = request.getParameter("embedded");
            return path.equalsIgnoreCase(LOGIN_PATH) && Boolean.parseBoolean(embedded);
        }));
        this.pluginsServletPatternMatchers = this.collectPathPatterns(propertiesService, X_FRAME_OPTIONS_PLUGINS_SERVLET_PATH_PROPERTY);
        this.mandatoryListByHeader = ImmutableMap.of((Object)X_FRAME_OPTIONS, (Object)ImmutableList.of((request, path) -> path.startsWith(PLUGINS_SERVLET_PATH_PREFIX) && this.anyMatching(this.pluginsServletPatternMatchers, request, path)));
    }

    private boolean anyMatching(List<BiFunction<HttpServletRequest, String, Boolean>> servletPluginPatterns, HttpServletRequest request, String path) {
        return servletPluginPatterns.stream().anyMatch(pattern -> (Boolean)pattern.apply(request, path));
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.shouldSetHeader(request, response, X_XSS_PROTECTION)) {
            response.setHeader(X_XSS_PROTECTION, "1; mode=block");
        }
        if (this.shouldSetHeader(request, response, X_FRAME_OPTIONS)) {
            response.setHeader(X_FRAME_OPTIONS, "SAMEORIGIN");
        }
        response.setHeader(X_CONTENT_TYPE_OPTIONS, "nosniff");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private List<BiFunction<HttpServletRequest, String, Boolean>> collectPathPatterns(InternalApplicationPropertiesService propertiesService, String pathPatternProperty) {
        return Splitter.on((Pattern)Pattern.compile("\\s+")).splitToList((CharSequence)propertiesService.getProperty(pathPatternProperty, "")).stream().map(StringUtils::trimToNull).filter(Objects::nonNull).map(pattern -> this.toValidPattern(pathPatternProperty, pattern)).filter(Optional::isPresent).map(Optional::get).map(pattern -> (request, path) -> pattern.matcher(path.substring(PLUGINS_SERVLET_PATH_PREFIX.length() - 1)).matches()).collect(Collectors.toList());
    }

    private boolean isRequestExemptFromHeader(String header, HttpServletRequest request) {
        return this.isListed(header, request, this.exemptListByHeader);
    }

    private boolean isHeaderMandatoryForRequest(String header, HttpServletRequest request) {
        return this.isListed(header, request, this.mandatoryListByHeader);
    }

    private boolean isListed(String header, HttpServletRequest request, Map<String, Iterable<BiFunction<HttpServletRequest, String, Boolean>>> listByHeader) {
        String path = request.getServletPath() + request.getPathInfo();
        return listByHeader.containsKey(header) && Iterables.any(listByHeader.get(header), matcher -> (Boolean)matcher.apply(request, path));
    }

    private boolean shouldSetHeader(HttpServletRequest request, HttpServletResponse response, String header) {
        String lcHeader = header.toLowerCase();
        return !response.containsHeader(lcHeader) && (this.isHeaderMandatoryForRequest(lcHeader, request) || !this.isRequestExemptFromHeader(lcHeader, request));
    }

    private Optional<Pattern> toValidPattern(String property, String pattern) {
        try {
            return Optional.of(Pattern.compile(pattern));
        }
        catch (Exception e) {
            log.warn("Invalid regex for property {}: {}. Standard headers will not be applied to URLs for this path pattern", new Object[]{property, pattern, e});
            return Optional.empty();
        }
    }
}

