/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.atlassian.stash.internal.web.filters.SiteMeshDataContributor;
import com.atlassian.stash.internal.web.filters.SoyDecoratorSelector;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.DecoratorSelector;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import com.opensymphony.sitemesh.webapp.decorator.NoDecorator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SoyDecoratorSelector
implements DecoratorSelector {
    private static final String DECORATOR_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-web:server-soy-decorators";
    private static final Map<String, String> DECORATORS_TO_TEMPLATES = ImmutableMap.builder().put((Object)"atl.general", (Object)"bitbucket.decorators.atlassian.general").put((Object)"atl.popup", (Object)"bitbucket.decorators.atlassian.popup").put((Object)"atl.userprofile", (Object)"bitbucket.decorators.users.account").put((Object)"atl.admin", (Object)"bitbucket.decorators.atlassian.admin").put((Object)"bitbucket.form", (Object)"bitbucket.decorators.atlassian.focusedPageLarge").put((Object)"bitbucket.focused.small", (Object)"bitbucket.decorators.atlassian.focusedPageSmall").put((Object)"bitbucket.focused.medium", (Object)"bitbucket.decorators.atlassian.focusedPageMedium").put((Object)"bitbucket.focused.large", (Object)"bitbucket.decorators.atlassian.focusedPageLarge").put((Object)"bitbucket.focused.xlarge", (Object)"bitbucket.decorators.atlassian.focusedPageXLarge").put((Object)"bitbucket.project.general", (Object)"bitbucket.decorators.project.general").put((Object)"bitbucket.project.settings", (Object)"bitbucket.decorators.project.settings").put((Object)"bitbucket.repository.general", (Object)"bitbucket.decorators.repository.general").put((Object)"bitbucket.repository.settings", (Object)"bitbucket.decorators.repository.settings").put((Object)"bitbucket.pullrequest.view", (Object)"bitbucket.decorators.pullrequest.view").put((Object)"bitbucket.users.account", (Object)"bitbucket.decorators.users.account").put((Object)"bitbucket.users.profile", (Object)"bitbucket.decorators.users.profile").put((Object)"bitbucket.internal.mirror", (Object)"bitbucket.decorators.atlassian.mirror").put((Object)"bitbucket.internal.setup", (Object)"bitbucket.decorators.atlassian.setup").put((Object)"bitbucket.internal.connect.panel", (Object)"bitbucket.decorators.atlassian.connectPanel").put((Object)"bitbucket.internal.mirror.cloudStpPanel", (Object)"bitbucket.decorators.atlassian.cloudStpPanel").build();
    private final SiteMeshDataContributor dataContributor;
    private final InjectedDataFactory injectedDataFactory;
    private final SoyTemplateRenderer templateRenderer;

    @Autowired
    public SoyDecoratorSelector(SiteMeshDataContributor dataContributor, InjectedDataFactory injectedDataFactory, SoyTemplateRenderer templateRenderer) {
        this.dataContributor = dataContributor;
        this.injectedDataFactory = injectedDataFactory;
        this.templateRenderer = templateRenderer;
    }

    public Decorator selectDecorator(Content content, SiteMeshContext context) {
        String templateName = this.selectTemplate(content, context);
        return templateName == null ? new NoDecorator() : new SoyDecorator(this, templateName);
    }

    private String selectTemplate(Content content, SiteMeshContext context) {
        SiteMeshWebAppContext webAppContext = (SiteMeshWebAppContext)context;
        String templateName = this.getTemplateFromAttribute(webAppContext.getRequest(), "decorator");
        if (templateName == null && (templateName = this.getTemplateFromProperty(content, "decorator")) == null) {
            templateName = this.getTemplateFromProperty(content, "meta.decorator");
        }
        String override = this.getTemplateFromAttribute(webAppContext.getRequest(), "decorator.override");
        return templateName != null && override != null ? override : templateName;
    }

    private String getTemplateFromProperty(Content content, String propertyName) {
        String decorator = content.getProperty(propertyName);
        return (String)DECORATORS_TO_TEMPLATES.get(decorator);
    }

    private String getTemplateFromAttribute(HttpServletRequest request, String attributeName) {
        Object decorator = request.getAttribute(attributeName);
        return decorator instanceof String ? (String)DECORATORS_TO_TEMPLATES.get(decorator) : null;
    }

    static /* synthetic */ SiteMeshDataContributor access$000(SoyDecoratorSelector x0) {
        return x0.dataContributor;
    }

    static /* synthetic */ InjectedDataFactory access$100(SoyDecoratorSelector x0) {
        return x0.injectedDataFactory;
    }

    static /* synthetic */ SoyTemplateRenderer access$200(SoyDecoratorSelector x0) {
        return x0.templateRenderer;
    }
}

