/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.dashboard;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dashboard.DashboardService;
import com.atlassian.bitbucket.dashboard.PullRequestSuggestion;
import com.atlassian.bitbucket.dashboard.SuggestPullRequestsRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.RecentlyAccessedRepositoriesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/dashboard"})
public class DashboardController {
    public static final int CLOSED_PULL_REQUEST_LIMIT = 25;
    public static final String NEXT_URL = "nextUrl";
    public static final String PULL_REQUESTS_CLOSED = "pullRequestsClosed";
    public static final String PULL_REQUESTS_CREATED = "pullRequestsCreated";
    public static final int PULL_REQUESTS_LIMIT = 25;
    public static final String PULL_REQUESTS_REVIEWING = "pullRequestsReviewing";
    public static final String PULL_REQUEST_SUGGESTIONS = "pullRequestSuggestions";
    public static final String RECENT_REPOSITORIES = "recentRepositories";
    public static final int REPOSITORIES_LIST_LIMIT = 10;
    public static final int SUGGESTED_PULL_REQUESTS_LIMIT = 3;
    public static final String VIEW = "bitbucket.internal.page.dashboard";
    private static final long CLOSED_SINCE = TimeUnit.DAYS.toMillis(7L);
    private final AuthenticationContext authenticationContext;
    private final DashboardService dashboardService;
    private final NavBuilder navBuilder;
    private final ProjectService projectService;
    private final PullRequestService pullRequestService;
    private final RecentlyAccessedRepositoriesService recentRepositoriesService;

    @Autowired
    public DashboardController(AuthenticationContext authenticationContext, DashboardService dashboardService, NavBuilder navBuilder, ProjectService projectService, PullRequestService pullRequestService, RecentlyAccessedRepositoriesService recentRepositoriesService) {
        this.authenticationContext = authenticationContext;
        this.dashboardService = dashboardService;
        this.navBuilder = navBuilder;
        this.projectService = projectService;
        this.pullRequestService = pullRequestService;
        this.recentRepositoriesService = recentRepositoriesService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView dashboard() {
        if (!this.authenticationContext.isAuthenticated()) {
            return new ModelAndView("redirect:" + this.navBuilder.login().buildRelNoContext(), (Map)ImmutableMap.of((Object)NEXT_URL, (Object)this.navBuilder.dashboard().buildRelNoContext()));
        }
        Page recentRepositories = this.getRepositories();
        if (recentRepositories.getSize() == 0 && this.projectService.findAll(PageUtils.newRequest((int)0, (int)1)).getSize() == 0) {
            return new ModelAndView("redirect:" + this.navBuilder.allProjects().buildRelNoContext());
        }
        return this.renderDashboard(this.getSuggestedPullRequests(), this.getCreatedPullRequests(), this.getReviewingPullRequests(), this.getClosedPullRequests(), recentRepositories);
    }

    private Page<PullRequest> getClosedPullRequests() {
        PullRequestSearchRequest created = new PullRequestSearchRequest.Builder().order(PullRequestOrder.CLOSED_DATE).closedSince(new Date(System.currentTimeMillis() - CLOSED_SINCE)).participant(new PullRequestParticipantRequest.Builder(this.authenticationContext.getCurrentUser().getName()).role(PullRequestRole.AUTHOR).build()).build();
        Page createdPullRequests = this.pullRequestService.search(created, PageUtils.newRequest((int)0, (int)25));
        PullRequestSearchRequest reviewed = new PullRequestSearchRequest.Builder().order(PullRequestOrder.CLOSED_DATE).closedSince(new Date(System.currentTimeMillis() - CLOSED_SINCE)).participant(new PullRequestParticipantRequest.Builder(this.authenticationContext.getCurrentUser().getName()).role(PullRequestRole.REVIEWER).build()).build();
        Page reviewedPullRequests = this.pullRequestService.search(reviewed, PageUtils.newRequest((int)0, (int)25));
        return PageUtils.createPage((Iterable)Stream.concat(createdPullRequests.stream(), reviewedPullRequests.stream()).sorted((a, b) -> b.getClosedDate().compareTo(a.getClosedDate())).limit(25L).collect(Collectors.toList()), (createdPullRequests.getIsLastPage() && reviewedPullRequests.getIsLastPage() && createdPullRequests.getSize() + reviewedPullRequests.getSize() <= 25 ? 1 : 0) != 0, (PageRequest)PageUtils.newRequest((int)0, (int)25));
    }

    private Page<PullRequest> getCreatedPullRequests() {
        PullRequestSearchRequest request = new PullRequestSearchRequest.Builder().order(PullRequestOrder.PARTICIPANT_STATUS).participant(new PullRequestParticipantRequest.Builder(this.authenticationContext.getCurrentUser().getName()).role(PullRequestRole.AUTHOR).build()).state(PullRequestState.OPEN).build();
        return this.pullRequestService.search(request, PageUtils.newRequest((int)0, (int)25));
    }

    private Page<Repository> getRepositories() {
        return this.recentRepositoriesService.findByCurrentUser(Permission.REPO_READ, PageUtils.newRequest((int)0, (int)10));
    }

    private Page<PullRequest> getReviewingPullRequests() {
        PullRequestSearchRequest request = new PullRequestSearchRequest.Builder().order(PullRequestOrder.PARTICIPANT_STATUS).participant(new PullRequestParticipantRequest.Builder(this.authenticationContext.getCurrentUser().getName()).role(PullRequestRole.REVIEWER).build()).state(PullRequestState.OPEN).build();
        return this.pullRequestService.search(request, PageUtils.newRequest((int)0, (int)25));
    }

    private Page<PullRequestSuggestion> getSuggestedPullRequests() {
        return this.dashboardService.suggestPullRequests(new SuggestPullRequestsRequest.Builder(this.authenticationContext.getCurrentUser(), new DateTime().minusHours(24).toDate()).limit(3).build());
    }

    private ModelAndView renderDashboard(Page<PullRequestSuggestion> pullRequestSuggestions, Page<PullRequest> createdPulRequests, Page<PullRequest> reviewingPullRequests, Page<PullRequest> closedPullRequests, Page<Repository> recentRepositories) {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put(PULL_REQUEST_SUGGESTIONS, pullRequestSuggestions)).put(PULL_REQUESTS_CREATED, createdPulRequests)).put(PULL_REQUESTS_REVIEWING, reviewingPullRequests)).put(PULL_REQUESTS_CLOSED, closedPullRequests)).put(RECENT_REPOSITORIES, recentRepositories)).build();
    }
}

