/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.attach;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.AttachmentUri;
import com.atlassian.fugue.Either;
import com.atlassian.stash.internal.attach.AttachmentService;
import com.atlassian.stash.internal.attach.AttachmentSupplier;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.web.attach.AttachmentController;
import com.atlassian.stash.internal.web.attach.AttachmentForm;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.util.DownloadHeaderHelper;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/attachments"})
public class AttachmentController
extends RepositoryControllerSupport {
    private final AttachmentService attachmentService;
    private final DownloadHeaderHelper downloadHeaderHelper;
    private final NavBuilder navBuilder;

    @Autowired
    public AttachmentController(I18nService i18nService, RefService refService, PermissionService permissionService, InternalProjectService projectService, RepositoryService repositoryService, InternalScmService scmService, AttachmentService attachmentService, DownloadHeaderHelper downloadHeaderHelper, NavBuilder navBuilder) {
        super(i18nService, refService, permissionService, projectService, repositoryService, scmService);
        this.attachmentService = attachmentService;
        this.downloadHeaderHelper = downloadHeaderHelper;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{token}/**"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="token") String token, @RequestParam(value="attachmentName") String attachmentName) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.attachmentService.delete(repository, AttachmentController.toId((String)token, (String)attachmentName));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{token}/**"})
    public void retrieve(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="token") String token, @RequestParam(value="attachmentName") String attachmentName, @RequestHeader(value="User-Agent", required=false) String userAgent, HttpServletResponse response) throws IOException {
        Repository repository = this.getRepository(projectKey, repoSlug);
        AttachmentSupplier supplier = this.attachmentService.read(repository, AttachmentController.toId((String)token, (String)attachmentName));
        1 source = new /* Unavailable Anonymous Inner Class!! */;
        source.copyTo((OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    @IgnoresXsrf
    @RequestMapping(consumes={"multipart/form-data"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, Object>> save(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, AttachmentForm attachments) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        List ids = this.attachmentService.saveAll(repository, attachments.toSuppliers());
        Function<Either, RestAttachment> transform = either -> (RestAttachment)either.fold(RestAttachment::new, id -> this.createRestAttachment(id, repository));
        return new ResponseEntity((Object)new RestAttachments(ids.stream().map(transform).collect(Collectors.toList())), HttpStatus.CREATED);
    }

    private static String toId(String token, String attachmentName) {
        return token + "/" + attachmentName;
    }

    private RestAttachment createRestAttachment(String id, Repository repository) {
        String url = this.navBuilder.repo(repository).attachments().attachment(id).buildAbsolute();
        AttachmentUri attachmentUri = new AttachmentUri(repository.getId(), id);
        return new RestAttachment(id, url, attachmentUri.toString());
    }

    static /* synthetic */ DownloadHeaderHelper access$000(AttachmentController x0) {
        return x0.downloadHeaderHelper;
    }
}

