/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin"})
public class UserAndGroupListController {
    private static final String USER_LIST = "bitbucket.internal.admin.users.list";
    private static final String GROUP_LIST = "bitbucket.internal.admin.groups.list";
    private final UserAdminService userAdminService;

    @Autowired
    public UserAndGroupListController(UserAdminService userAdminService) {
        this.userAdminService = userAdminService;
    }

    @RequestMapping(value={"/groups"}, method={RequestMethod.GET})
    public ModelAndView listGroups(@RequestParam(value="filter", required=false, defaultValue="") String filter) {
        Page groups = this.userAdminService.findGroupsByName(filter, PageUtils.newRequest((int)0, (int)50));
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(GROUP_LIST).put("filter", (Object)filter)).put("groupPage", (Object)groups)).build();
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET})
    public ModelAndView listUsers(@RequestParam(value="filter", required=false, defaultValue="") String filter) {
        Page users = this.userAdminService.findUsersByName(filter, PageUtils.newRequest((int)0, (int)50));
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(USER_LIST).put("canCreateUsers", (Object)this.userAdminService.canCreateUsers())).put("filter", (Object)filter)).put("userPage", (Object)users)).build();
    }
}

