/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSearchRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectCreateRequest;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectUpdateRequest;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.web.admin.MergeStrategyAdminHelper;
import com.atlassian.stash.internal.web.admin.ProjectForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.AvatarSupport;
import com.atlassian.stash.internal.web.util.StashWebErrorUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/projects"})
public class ProjectAdminController
extends AvatarSupport {
    public static final String PAGE_HOOK_SETTINGS = "bitbucket.internal.page.project.settings.hooks";
    public static final String PAGE_MERGE_CHECK_SETTINGS = "bitbucket.internal.page.project.settings.mergeChecks";
    public static final String PROJECT_CREATE = "bitbucket.internal.page.createProject";
    public static final String PROJECT_EDIT_SETTINGS = "bitbucket.internal.page.project.settings.general";
    public static final String PROJECT_LIST = "bitbucket.internal.page.projectList";
    public static final String PROJECT_MERGE_STRATEGIES_SETTINGS = "bitbucket.internal.page.projectMergeStrategiesSettings";
    private final InternalAvatarService avatarService;
    private final HelpPathService helpPathService;
    private final RepositoryHookService hookService;
    private final NavBuilder navBuilder;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final InternalProjectService projectService;
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;
    private final InternalScmService scmService;

    @Autowired
    public ProjectAdminController(InternalAvatarService avatarService, HelpPathService helpPathService, RepositoryHookService hookService, I18nService i18nService, NavBuilder navBuilder, PermissionService permissionService, PermissionValidationService permissionValidationService, InternalProjectService projectService, PullRequestService pullRequestService, RepositoryService repositoryService, InternalScmService scmService) {
        super(i18nService);
        this.avatarService = avatarService;
        this.helpPathService = helpPathService;
        this.hookService = hookService;
        this.navBuilder = navBuilder;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.projectService = projectService;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
    }

    @RequestMapping(params={"create"}, method={RequestMethod.POST})
    public ModelAndView createProject(@Valid ProjectForm form, Errors errors) {
        StashSoyResponseBuilder responseBuilder = new StashSoyResponseBuilder(PROJECT_CREATE);
        ArrayList detailedErrors = Lists.newArrayList();
        if (!errors.hasErrors()) {
            try {
                Project project = this.projectService.create(((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)new ProjectCreateRequest.Builder().key(form.getKey())).name(form.getName())).description(form.getDescription())).avatarUri(form.getAvatar()).build());
                return new ModelAndView((View)new RedirectView(this.navBuilder.project(project.getKey()).buildRelNoContext(), true));
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        return ((StashSoyResponseBuilder)responseBuilder.putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).put("projectForm", (Object)form)).build();
    }

    @RequestMapping(params={"create"}, method={RequestMethod.GET})
    public ModelAndView createProjectView() {
        if (this.permissionService.hasGlobalPermission(Permission.PROJECT_CREATE)) {
            return new StashSoyResponseBuilder(PROJECT_CREATE).build();
        }
        throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.project.create.accessdenied", new Object[0]));
    }

    @RequestMapping(value={"{projectKey}"}, params={"delete"}, method={RequestMethod.POST})
    public RedirectView deleteProject(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null || !this.projectService.delete(project)) {
            throw this.newNoSuchProjectException(projectKey);
        }
        return new RedirectView(this.navBuilder.allProjects().buildRelNoContext(), true);
    }

    @RequestMapping(value={"{projectKey}/settings"}, method={RequestMethod.GET})
    public ModelAndView editProject(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.getProject(projectKey);
        if (project.getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.web.project.edit.personalunmodifiable", new Object[0]));
        }
        if (this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return new StashSoyResponseBuilder(PROJECT_EDIT_SETTINGS).putProject(project).build();
        }
        throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.project.edit.accessdenied", new Object[]{project.getName()}));
    }

    @RequestMapping(value={"{projectKey}/settings/hooks"})
    public ModelAndView getHooks(@PathVariable(value="projectKey") String projectKey) {
        ProjectScope scope = Scopes.project((Project)this.getProject(projectKey));
        Page preReceiveHookPage = this.hookService.search(new RepositoryHookSearchRequest.Builder((Scope)scope).type(RepositoryHookType.PRE_RECEIVE).build(), PageUtils.newRequest((int)0, (int)25));
        Page postReceiveHookPage = this.hookService.search(new RepositoryHookSearchRequest.Builder((Scope)scope).type(RepositoryHookType.POST_RECEIVE).build(), PageUtils.newRequest((int)0, (int)25));
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_HOOK_SETTINGS).putProject(scope.getProject()).put("preReceiveHookPage", (Object)preReceiveHookPage)).put("postReceiveHookPage", (Object)postReceiveHookPage)).put("scope", (Object)scope)).build();
    }

    @RequestMapping(value={"{projectKey}/settings/merge-checks"})
    public ModelAndView getMergeChecks(@PathVariable(value="projectKey") String projectKey) {
        ProjectScope scope = Scopes.project((Project)this.getProject(projectKey));
        Page prePullRequestMergeHookPage = this.hookService.search(new RepositoryHookSearchRequest.Builder((Scope)scope).type(RepositoryHookType.PRE_PULL_REQUEST_MERGE).build(), PageUtils.newRequest((int)0, (int)25));
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_MERGE_CHECK_SETTINGS).putProject(scope.getProject()).put("prePullRequestMergeHookPage", (Object)prePullRequestMergeHookPage)).put("scope", (Object)scope)).build();
    }

    @RequestMapping(value={"{projectKey}/settings/merge-strategies/{scmId}"})
    public ModelAndView getMergeStrategiesSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="scmId") String scmId) {
        Project project = this.getProjectFromKey(projectKey);
        if (!this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.settings.mergestrategy.nopermission", new Object[]{project.getName()}));
        }
        StashSoyResponseBuilder builder = new StashSoyResponseBuilder(PROJECT_MERGE_STRATEGIES_SETTINGS).putProject(project);
        PullRequestMergeConfig mergeConfig = this.pullRequestService.getMergeConfig(new GetPullRequestMergeConfigRequest.Builder(project, scmId).build());
        builder.put("mergeConfig", (Object)MergeStrategyAdminHelper.mergeConfigToMap((PullRequestMergeConfig)mergeConfig));
        String helpTopic = this.scmService.getMergeStrategies(scmId).getHelpTopic();
        String helpUrl = this.helpPathService.getPageUrl(helpTopic);
        builder.put("mergeStrategiesHelpUrl", (Object)(helpUrl == null ? helpTopic : helpUrl));
        return builder.build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getProjects(@RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        Page projects = this.projectService.findAll((PageRequest)new PageRequestImpl(start, limit));
        this.validatePage(projects);
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(PROJECT_LIST).put("projectPage", (Object)projects)).build();
    }

    @RequestMapping(value={"{projectKey}"}, method={RequestMethod.GET})
    public ModelAndView getProjectView(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.getProjectFromKey(projectKey);
        ApplicationUser owner = (ApplicationUser)project.accept((ProjectVisitor)new /* Unavailable Anonymous Inner Class!! */);
        if (owner != null) {
            return new ModelAndView("redirect:" + this.navBuilder.user(owner).buildRelNoContext());
        }
        Page repositoryPage = this.repositoryService.findByProjectKey(project.getKey(), (PageRequest)new PageRequestImpl(0, 1));
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.project.projectOverview").putProject(project).put("repositoryPage", (Object)repositoryPage)).build();
    }

    @ExceptionHandler(value={NoSuchEntityException.class})
    public ModelAndView handleNoSuchProject(NoSuchEntityException exception, HttpServletResponse response) {
        response.setStatus(404);
        return new ModelAndView("bitbucket.internal.errors.project404", "error", (Object)exception);
    }

    @RequestMapping(value={"{projectKey}/avatar.png"}, method={RequestMethod.GET}, produces={"image/png"})
    public void retrieveAvatar(@PathVariable(value="projectKey") String projectKey, @RequestParam(defaultValue="256", value="s") int size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Project project;
        try {
            project = this.projectService.getByKey(projectKey);
        }
        catch (AuthorisationException e) {
            project = null;
        }
        CacheableAvatarSupplier supplier = project == null ? this.avatarService.getProjectDefault(size) : this.projectService.getAvatar(project.getId(), size);
        this.streamAvatar(supplier, request, response);
    }

    @RequestMapping(value={"{projectKey}/settings"}, method={RequestMethod.POST})
    public ModelAndView updateProject(@PathVariable(value="projectKey") String projectKey, @Valid ProjectForm form, Errors errors, RedirectAttributes redirectAttributes) {
        Project project = this.getProject(projectKey);
        StashSoyResponseBuilder responseBuilder = new StashSoyResponseBuilder(PROJECT_EDIT_SETTINGS);
        ArrayList detailedErrors = Lists.newArrayList();
        if (!errors.hasErrors()) {
            try {
                project = this.projectService.update(((ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)new ProjectUpdateRequest.Builder(project).key(form.getKey())).name(form.getName())).description(form.getDescription())).build());
                if (form.hasAvatar()) {
                    this.projectService.updateAvatar(project.getId(), form.getAvatar());
                }
                redirectAttributes.addFlashAttribute("isEditSuccess", (Object)true);
                return new ModelAndView("redirect:" + this.navBuilder.project(project.getKey()).settings().buildRelNoContext());
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        return ((StashSoyResponseBuilder)responseBuilder.putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).putProject(project).put("projectForm", (Object)form)).build();
    }

    private Project getProject(String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw this.newNoSuchProjectException(projectKey);
        }
        return project;
    }

    private Project getProjectFromKey(String projectKey) throws NoSuchProjectException {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            if (this.projectService.isPersonalProject(projectKey)) {
                project = this.projectService.getPersonalProject();
            } else {
                throw this.newNoSuchProjectException(projectKey);
            }
        }
        return project;
    }

    private void validatePage(Page<?> page) {
        if (page.getIsLastPage() && page.getSize() == 0 && page.getStart() == 0) {
            this.permissionValidationService.validateAuthenticated();
        }
    }
}

