/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mail.MailException;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.stash.internal.mail.InternalMailService;
import com.atlassian.stash.internal.web.admin.MailServerConfigurationController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import java.util.Arrays;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/admin/mail-server"})
public class MailServerConfigurationController {
    private static final Logger LOG = LoggerFactory.getLogger(MailServerConfigurationController.class);
    private static final String VIEW = "bitbucket.internal.admin.mailserverconfig";
    private static final String REDIRECT_URL = "redirect:/admin/mail-server";
    private final I18nService i18nService;
    private final InternalMailService mailService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public MailServerConfigurationController(InternalMailService mailService, I18nService i18nService, ApplicationPropertiesService propertiesService) {
        this.mailService = mailService;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showSettings() {
        Form config = this.loadConfig();
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.admin.mailserverconfig").put("isUnconfigured", (Object)(!this.mailService.isHostConfigured() ? 1 : 0))).put("config", (Object)config)).put("availableProtocols", Arrays.asList(MailProtocol.values()))).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView updateSettings(@Valid Form config, Errors errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            this.resetPasswordAndRenderErrorIfRequired(config, this.propertiesService.getMailHostConfiguration(), errors);
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.admin.mailserverconfig").put("config", (Object)config)).put("availableProtocols", Arrays.asList(MailProtocol.values()))).putValidationErrors(errors).build();
        }
        this.updateConfig(config);
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new ModelAndView("redirect:/admin/mail-server");
    }

    @RequestMapping(method={RequestMethod.POST}, params={"test"})
    public ModelAndView testSettings(@Valid TestForm config, Errors errors) {
        String configuredPassword;
        StashSoyResponseBuilder rb = (StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.admin.mailserverconfig").put("availableProtocols", Arrays.asList(MailProtocol.values()));
        MailHostConfiguration currentConfig = this.propertiesService.getMailHostConfiguration();
        String string = configuredPassword = currentConfig == null ? config.getPassword() : currentConfig.getPassword();
        if (errors.hasErrors()) {
            this.resetPasswordAndRenderErrorIfRequired((Form)config, currentConfig, errors);
            return ((StashSoyResponseBuilder)rb.put("config", (Object)config)).putValidationErrors(errors).build();
        }
        MailHostConfiguration.Builder mailHostConfigBuilder = new MailHostConfiguration.Builder().hostname(config.getHostname()).port(this.parsePort(config.getPort())).username(config.getUsername()).protocol(MailProtocol.fromString((String)config.getProtocol())).useStartTls(config.isUseTls()).requireStartTls(config.isRequireTls());
        mailHostConfigBuilder.password(config.isPasswordChanged() ? config.getPassword() : configuredPassword);
        this.resetPasswordAndRenderErrorIfRequired((Form)config, currentConfig, errors);
        try {
            this.mailService.sendTest(mailHostConfigBuilder.build(), new MailMessage.Builder().subject(this.i18nService.getMessage("bitbucket.web.admin.mail.test.subject", new Object[]{this.propertiesService.getDisplayName()})).text(this.i18nService.getMessage("bitbucket.web.admin.mail.test.body", new Object[]{this.propertiesService.getDisplayName()})).to(new String[]{config.getTestAddress()}).from(config.getServerEmail()).build());
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)rb.put("config", (Object)config)).put("tested", (Object)true)).putValidationErrors(errors).build();
        }
        catch (MailException e) {
            LOG.warn(String.format("Failed to send a test email message to %s", config.getTestAddress()), (Throwable)e);
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)rb.put("config", (Object)config)).put("tested", (Object)true)).put("testFailureMessage", (Object)e.getLocalizedMessage())).putValidationErrors(errors).build();
        }
    }

    private Form loadConfig() {
        MailHostConfiguration configuration = this.propertiesService.getMailHostConfiguration();
        Form form = new Form();
        if (configuration != null) {
            Form.access$002((Form)form, (String)configuration.getHostname());
            Form.access$102((Form)form, configuration.getPort() != null ? configuration.getPort().toString() : null);
            Form.access$202((Form)form, (String)configuration.getUsername());
            Form.access$302((Form)form, (boolean)StringUtils.isNotEmpty((CharSequence)configuration.getPassword()));
            Form.access$402((Form)form, (String)this.propertiesService.getServerEmailAddress());
            Form.access$502((Form)form, (String)configuration.getProtocol().name());
            Form.access$602((Form)form, (boolean)configuration.isUseStartTls());
            Form.access$702((Form)form, (boolean)configuration.isRequireStartTls());
        }
        return form;
    }

    private void updateConfig(Form form) {
        MailHostConfiguration.Builder newConfigBuilder = new MailHostConfiguration.Builder().hostname(form.getHostname()).port(this.parsePort(form.getPort())).username(form.getUsername()).protocol(MailProtocol.fromString((String)form.getProtocol())).useStartTls(form.isUseTls()).requireStartTls(form.isRequireTls());
        if (StringUtils.isEmpty((CharSequence)Form.access$200((Form)form))) {
            newConfigBuilder.password(null);
        } else if (Form.access$800((Form)form)) {
            newConfigBuilder.password(Form.access$900((Form)form));
        } else {
            MailHostConfiguration oldConfig = this.propertiesService.getMailHostConfiguration();
            if (oldConfig != null) {
                newConfigBuilder.password(oldConfig.getPassword());
            }
        }
        this.propertiesService.setMailHostConfiguration(newConfigBuilder.build());
        this.propertiesService.setServerEmailAddress(form.getServerEmail());
    }

    private Integer parsePort(String port) {
        return port != null ? Integer.valueOf(Integer.parseInt(port)) : null;
    }

    private void resetPasswordAndRenderErrorIfRequired(Form form, MailHostConfiguration savedConfig, Errors errors) {
        if (form.isPasswordChanged()) {
            form.setPasswordSet(savedConfig == null ? false : StringUtils.isNotEmpty((CharSequence)savedConfig.getPassword()));
            KeyedMessage keyedMessage = this.i18nService.createKeyedMessage("bitbucket.web.admin.mail.password.not.updated", new Object[0]);
            errors.rejectValue("password", keyedMessage.getKey(), keyedMessage.getLocalisedMessage());
        }
    }
}

