/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.stash.internal.web.admin.GroupCreateController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/groups"}, params={"create"})
public class GroupCreateController
extends ControllerSupport {
    private static final String FORM_VIEW = "bitbucket.internal.admin.groups.create";
    private final UserAdminService adminService;
    private final PermissionService permissionService;
    private final NavBuilder navBuilder;

    @Autowired
    public GroupCreateController(I18nService i18nService, UserAdminService adminService, NavBuilder navBuilder, PermissionService permissionService) {
        super(i18nService);
        this.adminService = adminService;
        this.navBuilder = navBuilder;
        this.permissionService = permissionService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showForm() {
        if (this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            return new StashSoyResponseBuilder(FORM_VIEW).build();
        }
        throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.group.create.accessdenied", new Object[0]));
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView createGroup(@Valid GroupForm groupForm, Errors errors) {
        String name = StringUtils.trim((String)groupForm.getName());
        if (!errors.hasErrors()) {
            try {
                this.adminService.createGroup(name);
                return new ModelAndView("redirect:" + this.navBuilder.admin().groups().view(name).buildRelNoContext());
            }
            catch (IntegrityException e) {
                errors.rejectValue("name", e.getMessageKey(), e.getLocalizedMessage());
            }
            catch (CrowdRuntimeException e) {
                return this.handleCrowdException(e, groupForm);
            }
        }
        return this.showForm(groupForm).putValidationErrors(errors).build();
    }

    private ModelAndView handleCrowdException(CrowdRuntimeException e, GroupForm groupForm) {
        String name = groupForm.getName();
        this.log.error(String.format("The group %s could not be created", name), (Throwable)e);
        String error = this.i18nService.getMessage("bitbucket.web.group.create.crowdError", new Object[]{name});
        return ((StashSoyResponseBuilder)this.showForm(groupForm).putFormErrors(new String[]{error})).build();
    }

    private StashSoyResponseBuilder showForm(GroupForm groupForm) {
        return (StashSoyResponseBuilder)new StashSoyResponseBuilder(FORM_VIEW).put("groupForm", (Object)groupForm);
    }
}

