/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.backup.Backup;
import com.atlassian.stash.internal.backup.BackupService;
import com.atlassian.stash.internal.maintenance.MaintenanceLock;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.UnsupportedMaintenanceException;
import com.atlassian.stash.internal.web.admin.RestBackupFeature;
import com.atlassian.stash.internal.web.admin.RestBackupPage;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.maintenance.RestErrorTexts;
import com.atlassian.stash.internal.web.maintenance.RestMaintenanceTaskHandle;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/admin/backups"})
public class BackupController {
    public static final String LATEST = "latest";
    private final BackupService backupService;
    private final MaintenanceService maintenanceService;

    @Autowired
    public BackupController(BackupService backupService, MaintenanceService maintenanceService) {
        this.backupService = backupService;
        this.maintenanceService = maintenanceService;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"{name}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteBackup(@PathVariable(value="name") String name) {
        Backup backup = this.backupService.findByName(name);
        if (backup != null) {
            this.backupService.delete(backup);
        }
    }

    @RequestMapping(value={"{name}"})
    public void downloadBackup(@PathVariable(value="name") String name, HttpServletResponse response) throws IOException {
        Backup backup = LATEST.equals(name) ? this.backupService.getLatest() : this.backupService.getByName(name);
        response.setStatus(200);
        response.setContentType("application/zip");
        response.setHeader("Content-Length", Long.toString(backup.getSize()));
        response.setHeader("Content-Disposition", "attachment; filename=\"" + backup.getName() + "\"");
        try (InputStream backupStream = backup.getInput();){
            ByteStreams.copy((InputStream)backupStream, (OutputStream)response.getOutputStream());
        }
        response.flushBuffer();
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public RestBackupPage listBackups(@RequestParam(defaultValue="0", required=false, value="start") int start, @RequestParam(defaultValue="25", required=false, value="limit") int limit) {
        Page page = this.backupService.findAll(PageUtils.newRequest((int)start, (int)limit));
        return new RestBackupPage(page);
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @ResponseBody
    public RestMaintenanceTaskHandle startBackup(@RequestParam(defaultValue="false", required=false, value="external") boolean external) {
        if (external) {
            return new RestMaintenanceTaskHandle(this.backupService.externalBackup());
        }
        return new RestMaintenanceTaskHandle(this.backupService.backup());
    }

    @IgnoresXsrf
    @RequestMapping(value={"/progress/client"}, method={RequestMethod.POST}, produces={"application/json"}, params={"token", "percentage"})
    public void updateClientProgress(@RequestParam(value="token") String token, @RequestParam(value="percentage") int percentage, HttpServletResponse response) throws IOException {
        MaintenanceLock context = this.maintenanceService.getLock();
        if (context == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        if (!context.getUnlockToken().equals(token)) {
            response.setStatus(HttpStatus.CONFLICT.value());
            return;
        }
        try {
            this.backupService.updateClientProgress(percentage);
            response.setStatus(HttpStatus.ACCEPTED.value());
        }
        catch (NoSuchEntityException e) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
        }
    }

    @RequestMapping(method={RequestMethod.GET}, params={"features"}, produces={"application/json"})
    @ResponseBody
    public List<RestBackupFeature> getFeatures() {
        return Lists.transform((List)this.backupService.getFeatures(), RestBackupFeature::new);
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public RestErrorTexts handleInProgress(Exception e) {
        return new RestErrorTexts(new String[]{e.getLocalizedMessage()});
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={UnsupportedMaintenanceException.class})
    @ResponseBody
    public RestErrorTexts handleUnsupported(Exception e) {
        return new RestErrorTexts(new String[]{e.getLocalizedMessage()});
    }
}

