/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.stash.internal.util.InternalDateFormatter;
import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class StashDateFormatWebResourceTransformer
implements WebResourceTransformerFactory,
TransformerUrlBuilder,
UrlReadingWebResourceTransformer {
    private static final Pattern PATTERN = Pattern.compile("date_format\\(\\s*(['\"])([\\w.-]+)\\1\\s*\\)");
    private final InternalDateFormatter dateFormatter;

    public StashDateFormatWebResourceTransformer(InternalDateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return this;
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return this;
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        urlBuilder.addToHash("dateFormats", (Object)this.dateFormatter.getStateHash());
    }

    public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @VisibleForTesting
    String doTransform(CharSequence originalContent) {
        Matcher matcher = PATTERN.matcher(originalContent);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String formatString = this.dateFormatter.getFormatString(matcher.group(2));
            matcher.appendReplacement(result, "");
            result.append("'").append(StringEscapeUtils.escapeEcmaScript((String)StringUtils.defaultString((String)formatString))).append("'");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

