/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.ServletContextAware;

@Controller
public class RobotController
implements ServletContextAware {
    private final StorageService storageService;
    private ServletContext servletContext;

    @Autowired
    public RobotController(StorageService storageService) {
        this.storageService = storageService;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/robot", "/robot.txt", "/robots", "/robots.txt"})
    public ResponseEntity<Resource> robots() {
        Path robotsTxt = Stream.of(this.storageService.getHomeDir(), this.storageService.getSharedHomeDir()).map(dir -> dir.resolve("robots.txt")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElseGet(() -> Paths.get(this.servletContext.getRealPath("/robots.txt"), new String[0]));
        return ResponseEntity.ok().contentLength(MoreFiles.size((Path)robotsTxt)).contentType(MediaType.TEXT_PLAIN).body((Object)new PathResource(robotsTxt));
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

