/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.CachePolicies;
import java.net.MalformedURLException;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/about"})
public class AboutController {
    public static final String VIEW = "bitbucket.internal.page.about";
    private final ApplicationPropertiesService appPropService;
    private final ServletContextFactory servletContextFactory;

    @Autowired
    public AboutController(ApplicationPropertiesService appPropService, ServletContextFactory servletContextFactory) {
        this.appPropService = appPropService;
        this.servletContextFactory = servletContextFactory;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showAbout(HttpServletResponse response) throws MalformedURLException {
        CachePolicies.cacheForFourWeeks((HttpServletResponse)response);
        boolean showLicenses = this.servletContextFactory.getServletContext().getResource("/static/page/about/lgpl.soy") != null;
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("showLicenses", (Object)showLicenses)).put("copyrightStartYear", (Object)2012)).put("copyrightEndYear", (Object)this.calcEndCopyrightYear())).put("hideProfile", (Object)(this.appPropService.getMode() == ApplicationMode.MIRROR ? 1 : 0))).build();
    }

    private int calcEndCopyrightYear() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.appPropService.getBuildTimestamp());
        return cal.get(1);
    }
}

