/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationSystemException;
import com.atlassian.bitbucket.auth.CaptchaAuthenticationException;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.InactiveUserAuthenticationException;
import com.atlassian.bitbucket.auth.NoAccessAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.auth.InternalAuthenticationService;
import com.atlassian.stash.internal.spring.security.HttpAuthenticationContextToken;
import com.atlassian.stash.internal.user.InternalPermissionService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="authenticationProvider")
public class PluginAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(PluginAuthenticationProvider.class);
    private final InternalAuthenticationService authenticationService;
    private final I18nService i18nService;
    private final InternalPermissionService permissionService;

    @Autowired
    public PluginAuthenticationProvider(InternalAuthenticationService authenticationService, I18nService i18nService, InternalPermissionService permissionService) {
        this.authenticationService = authenticationService;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    @Profiled
    public Authentication authenticate(Authentication authentication) throws org.springframework.security.core.AuthenticationException {
        HttpAuthenticationContextToken authToken = (HttpAuthenticationContextToken)authentication;
        HttpAuthenticationContext context = authToken.getContext();
        try {
            Optional token = this.authenticationService.authenticate(context);
            token.ifPresent(t -> {
                if (!this.permissionService.hasGlobalPermission(t, Permission.LICENSED_USER)) {
                    throw new NoAccessAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.web.auth.notlicensed", new Object[]{Product.NAME}));
                }
            });
            return token.orElse(null);
        }
        catch (CaptchaAuthenticationException e) {
            log.debug("Authentication failed - CAPTCHA required");
            throw new LockedException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AuthenticationSystemException e) {
            log.warn("Could not authenticate {}", (Object)context.getUsername(), (Object)e);
            throw new AuthenticationServiceException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InactiveUserAuthenticationException e) {
            log.debug("Authentication failed - User is inactive");
            throw new DisabledException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (NoAccessAuthenticationException e) {
            log.debug("Authentication failed - User is not licensed");
            throw new DisabledException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AuthenticationException e) {
            log.debug("Authentication failed - Bad credentials");
            throw new BadCredentialsException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (NoSuchUserException e) {
            log.debug("Authentication failed - User not found");
            throw new BadCredentialsException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean supports(Class<?> aClass) {
        return HttpAuthenticationContextToken.class.isAssignableFrom(aClass);
    }
}

