/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.jmx;

import com.atlassian.stash.internal.concurrent.ClusterLockMXBeanAdapter;
import com.atlassian.stash.internal.concurrent.MonitoredClusterLockService;
import com.atlassian.stash.internal.concurrent.ThreadPoolMXBeanAdapter;
import com.atlassian.stash.internal.event.AsyncBatchingInvokersTransformer;
import com.atlassian.stash.internal.event.EventStatisticsMXBean;
import com.atlassian.stash.internal.event.EventThreadPoolExecutor;
import com.atlassian.stash.internal.event.TransactionAwareEventPublisher;
import com.atlassian.stash.internal.mail.MailServiceStatistics;
import com.atlassian.stash.internal.mail.MailServiceStatisticsMXBeanAdapter;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.project.ProjectMXBeanAdapter;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.repository.RepositoryMXBeanAdapter;
import com.atlassian.stash.internal.scm.ScmMXBean;
import com.atlassian.stash.internal.spring.jmx.JmxEnabledCondition;
import com.atlassian.stash.internal.throttle.InternalThrottleService;
import com.atlassian.stash.internal.throttle.TicketMXBeanAdapter;
import com.atlassian.stash.internal.throttle.TicketSummaryMXBeanAdapter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.support.RegistrationPolicy;

@Configuration
@Conditional(value={JmxEnabledCondition.class})
public class JmxWiring {
    @Value(value="${event.dispatcher.queue.size}")
    private int queueCapacity;

    @Bean
    public MBeanExporter mbeanExporter(@Qualifier(value="sessionFactory") SessionFactoryImplementor sessionFactory, @Qualifier(value="clusterLockService") MonitoredClusterLockService clusterLockService, InternalThrottleService throttleService, InternalProjectService internalProjectService, InternalRepositoryService internalRepositoryService, ScmMXBean scmMXBean, EventThreadPoolExecutor eventThreadPoolExecutor, TransactionAwareEventPublisher eventPublisher, AsyncBatchingInvokersTransformer invokersTransformer, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, @Qualifier(value="ioPumpThreadPoolExecutor") ThreadPoolExecutor ioPumpThreadPoolExecutor, @Qualifier(value="mailServiceStatistics") MailServiceStatistics mailServiceStatistics) {
        StatisticsImplementor statistics = sessionFactory.getStatistics();
        String statisticsMBeanName = String.format("%s:sessionFactory=%s,serviceRole=%s,serviceType=%s", "org.hibernate.core", sessionFactory.getSettings().getSessionFactoryName(), Statistics.class.getName(), statistics.getClass().getName());
        EventStatisticsMXBean eventMXBean = new EventStatisticsMXBean(eventPublisher, eventThreadPoolExecutor, invokersTransformer, this.queueCapacity);
        MBeanExporter exporter = new MBeanExporter();
        exporter.setBeans((Map)ImmutableMap.builder().put((Object)"com.atlassian.bitbucket:name=Tickets", (Object)new TicketMXBeanAdapter(throttleService)).put((Object)"com.atlassian.bitbucket:name=CommandTickets", (Object)new TicketSummaryMXBeanAdapter(throttleService, "scm-command")).put((Object)"com.atlassian.bitbucket:name=EventStatistics", (Object)eventMXBean).put((Object)"com.atlassian.bitbucket:name=HostingTickets", (Object)new TicketSummaryMXBeanAdapter(throttleService, "scm-hosting")).put((Object)"com.atlassian.bitbucket:name=ClusterLocks", (Object)new ClusterLockMXBeanAdapter(clusterLockService)).put((Object)"com.atlassian.bitbucket:name=Projects", (Object)new ProjectMXBeanAdapter(internalProjectService)).put((Object)"com.atlassian.bitbucket:name=Repositories", (Object)new RepositoryMXBeanAdapter(internalRepositoryService)).put((Object)"com.atlassian.bitbucket:name=ScmStatistics", (Object)scmMXBean).put((Object)"com.atlassian.bitbucket:name=MailStatistics", (Object)new MailServiceStatisticsMXBeanAdapter(mailServiceStatistics)).put((Object)"com.atlassian.bitbucket.thread-pools:name=EventThreadPool", (Object)new ThreadPoolMXBeanAdapter((ThreadPoolExecutor)eventThreadPoolExecutor)).put((Object)"com.atlassian.bitbucket.thread-pools:name=IoPumpThreadPool", (Object)new ThreadPoolMXBeanAdapter(ioPumpThreadPoolExecutor)).put((Object)"com.atlassian.bitbucket.thread-pools:name=ScheduledThreadPool", (Object)new ThreadPoolMXBeanAdapter((ThreadPoolExecutor)scheduledThreadPoolExecutor)).put((Object)statisticsMBeanName, (Object)statistics).build());
        exporter.setRegistrationPolicy(RegistrationPolicy.REPLACE_EXISTING);
        return exporter;
    }
}

