/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.protocol.http;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class HttpScmHostingFormFragment
implements ContextualFormFragment {
    private static final String FIELD_KEY = "httpEnabled";
    private static final String SOY_PARAM_ENABLED = "enabled";
    private static final String SOY_PARAM_PRODUCT = "product";
    private static final String TEMPLATE = "bitbucket.internal.feature.admin.scm.http";
    private final ApplicationPropertiesService applicationPropertiesService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public HttpScmHostingFormFragment(ApplicationPropertiesService applicationPropertiesService, SoyTemplateRenderer soyTemplateRenderer) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void doError(@Nonnull Appendable appendable, @Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        context.put(SOY_PARAM_ENABLED, this.isCheckBoxEnabled(requestParams));
        this.renderView(appendable, context);
    }

    public void doView(@Nonnull Appendable appendable, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(context, "context");
        context.put(SOY_PARAM_ENABLED, this.applicationPropertiesService.isHttpScmHostingEnabled());
        this.renderView(appendable, context);
    }

    public void execute(@Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        this.applicationPropertiesService.setHttpScmHostingEnabled(this.isCheckBoxEnabled(requestParams));
    }

    public void validate(@Nonnull Map<String, String[]> requestParams, @Nonnull ValidationErrors errors, @Nonnull Map<String, Object> context) {
    }

    private boolean isCheckBoxEnabled(Map<String, String[]> requestParams) {
        String[] values = requestParams.get(FIELD_KEY);
        return values != null && values.length == 1 && values[0].equalsIgnoreCase("on");
    }

    private void renderView(Appendable appendable, Map<String, Object> context) {
        try {
            context.put(SOY_PARAM_PRODUCT, Product.NAME);
            this.soyTemplateRenderer.render(appendable, "com.atlassian.bitbucket.server.bitbucket-web:server-soy-templates", TEMPLATE, context);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render bitbucket.internal.feature.admin.scm.http", (Throwable)e);
        }
    }
}

