/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.protocol.http;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheck;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpScmHostingCheck
implements ScmRequestCheck {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final I18nService i18nService;

    @Autowired
    public HttpScmHostingCheck(ApplicationPropertiesService applicationPropertiesService, I18nService i18nService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.i18nService = i18nService;
    }

    public boolean check(@Nonnull ScmRequest request) throws IOException {
        if (request instanceof HttpScmRequest && !this.applicationPropertiesService.isHttpScmHostingEnabled()) {
            request.sendError(this.i18nService.getMessage("bitbucket.scm.http.disabled", new Object[0]), this.i18nService.getMessage("bitbucket.scm.http.disabled.detail", new Object[0]));
            return false;
        }
        return true;
    }
}

