/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.ui.ValidationErrors;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.validation.Errors;

public class PluginValidationErrors
implements ValidationErrors {
    private final Errors errors;
    private final Multimap<String, String> fieldErrors;

    public PluginValidationErrors(@Nullable Errors errors) {
        this.errors = errors;
        this.fieldErrors = ArrayListMultimap.create();
    }

    public void addFieldError(String fieldName, String errorMessage) {
        this.fieldErrors.put((Object)fieldName, (Object)errorMessage);
    }

    public void addFormError(String errorMessage) {
        if (this.errors == null) {
            throw new IllegalStateException("Form errors cannot be added without a SpringMVC Errors context");
        }
        this.errors.reject(errorMessage, errorMessage);
    }

    @Nonnull
    public Map<String, Collection<String>> getFieldErrors() {
        return this.fieldErrors.asMap();
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.hasErrors() || this.hasFieldErrors();
    }

    public boolean hasFieldErrors() {
        return !this.fieldErrors.isEmpty();
    }
}

