/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class I18nStateHasher {
    private final ResettableLazyReference<String> hashLazyRef;

    @Autowired
    public I18nStateHasher(PluginAccessor pluginAccessor) {
        this.hashLazyRef = new /* Unavailable Anonymous Inner Class!! */;
    }

    public String get() {
        return (String)this.hashLazyRef.get();
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        if (this.pluginContainsI18nResources(event.getPlugin())) {
            this.hashLazyRef.reset();
        }
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (this.pluginContainsI18nResources(event.getPlugin())) {
            this.hashLazyRef.reset();
        }
    }

    private boolean pluginContainsI18nResources(Plugin plugin) {
        return plugin.getResourceDescriptors().stream().anyMatch(rd -> rd.getType().equals("i18n"));
    }

    static /* synthetic */ boolean access$000(I18nStateHasher x0, Plugin x1) {
        return x0.pluginContainsI18nResources(x1);
    }
}

