/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.lifecycle;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class DefaultStartupManager
implements StartupManager,
ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultStartupManager.class);
    private ServletContext servletContext;
    private volatile Progress progress = new ProgressImpl("Starting " + Product.FULL_NAME, 0);

    @Nonnull
    public Progress getProgress() {
        return this.progress;
    }

    public boolean isStarting() {
        return LifecycleUtils.isStarting((ServletContext)this.servletContext);
    }

    public void onProgress(@Nonnull Progress progress) {
        Progress oldProgress = this.progress;
        if (progress.getPercentage() < oldProgress.getPercentage()) {
            log.debug("Progress going backwards: {} {}% -> {} {}%!", new Object[]{oldProgress.getMessage(), oldProgress.getPercentage(), progress.getMessage(), progress.getPercentage()});
        }
        this.progress = progress;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

