/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson.handler.bean;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.johnson.AbstractHelpPathProvider;
import com.atlassian.stash.internal.johnson.handler.EventDetails;
import com.atlassian.stash.internal.johnson.handler.bean.BeanFailureHandler;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.BeanCreationException;

public class DataSourceFailureHandler
extends AbstractHelpPathProvider
implements BeanFailureHandler {
    public EventDetails handle(@Nonnull BeanCreationException exception) {
        return this.handledConnectionError(exception);
    }

    private EventDetails handledConnectionError(BeanCreationException e) {
        StringBuilder message = new StringBuilder("The database, as currently configured, is not accessible. ");
        Throwable rootCause = e.getRootCause();
        if (rootCause instanceof ClassNotFoundException) {
            String causeMessage = rootCause.getMessage();
            for (DbType dbType : DbType.values()) {
                if (!causeMessage.contains(dbType.getDriverClassName())) continue;
                AbstractHelpPathProvider.HelpDetails help = this.getHelp(dbType.getHelpKey(), "our documentation", "https://confluence.atlassian.com/x/qAqTE");
                message.append(Product.NAME).append(" is configured to use the ").append(dbType.getKey()).append(" driver (").append(dbType.getDriverClassName()).append(") but it is not available. Please follow the instructions to install the driver as per <a href=\"").append(help.getUrl()).append("\">").append(help.getTitle()).append("</a>.");
            }
        }
        return new EventDetails("database-unavailable", message.toString(), (Throwable)e);
    }
}

