/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.web;

import com.atlassian.bitbucket.internal.boot.web.CommonConnectorProperties;
import com.atlassian.bitbucket.internal.boot.web.ConnectorProperties;
import com.atlassian.stash.internal.web.ApplicationStatusServlet;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

/*
 * Exception performing whole class analysis ignored.
 */
@ConfigurationProperties(prefix="server")
public class ExtendedServerProperties
extends CommonConnectorProperties
implements EmbeddedServletContainerCustomizer,
ApplicationContextAware,
Ordered {
    private ApplicationContext applicationContext;
    private boolean requireSsl;

    public ExtendedServerProperties() {
        super("server");
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            TomcatEmbeddedServletContainerFactory tomcat = (TomcatEmbeddedServletContainerFactory)container;
            tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{this});
            tomcat.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
                if (this.requireSsl) {
                    ExtendedServerProperties.addSecurityConstraints((Context)context);
                }
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowServerInfo(false);
                valve.setShowReport(true);
                context.getParent().getPipeline().addValve((Valve)valve);
            }});
            Map propertiesByName = this.applicationContext.getBeansOfType(ConnectorProperties.class);
            if (!propertiesByName.isEmpty()) {
                String serverHeader = tomcat.getServerHeader();
                Charset uriEncoding = tomcat.getUriEncoding();
                propertiesByName.values().stream().map(properties -> {
                    Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
                    connector.setProperty("bindOnInit", "false");
                    if (serverHeader != null) {
                        connector.setAttribute("server", (Object)serverHeader);
                    }
                    if (uriEncoding != null) {
                        connector.setURIEncoding(uriEncoding.name());
                    }
                    properties.customize(connector);
                    return connector;
                }).forEach(xva$0 -> tomcat.addAdditionalTomcatConnectors(new Connector[]{xva$0}));
            }
        }
    }

    public int getOrder() {
        return 1;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static void addSecurityConstraints(Context context) {
        SecurityCollection robotsHttps = ExtendedServerProperties.createSecurityCollection((String)"/robots.txt", (String[])new String[]{"/robots", "/robot.txt", "/robot"});
        robotsHttps.addOmittedMethod("GET");
        SecurityCollection robotsHttp = ExtendedServerProperties.createSecurityCollection((String)"/robots.txt", (String[])new String[]{"/robots", "/robot.txt", "/robot"});
        robotsHttp.addMethod("GET");
        SecurityCollection statusHttps = ExtendedServerProperties.createSecurityCollection((String)"/status", (String[])new String[0]);
        SecurityCollection statusHttp = ExtendedServerProperties.createSecurityCollection((String)"/status", (String[])new String[0]);
        ApplicationStatusServlet.ALLOWED_METHODS.forEach(method -> {
            statusHttp.addMethod(method);
            statusHttps.addOmittedMethod(method);
        });
        SecurityCollection all = ExtendedServerProperties.createSecurityCollection((String)"/*", (String[])new String[0]);
        context.addConstraint(ExtendedServerProperties.createSecurityConstraint((String)"CONFIDENTIAL", (SecurityCollection[])new SecurityCollection[]{robotsHttps, statusHttps, all}));
        context.addConstraint(ExtendedServerProperties.createSecurityConstraint((String)"NONE", (SecurityCollection[])new SecurityCollection[]{robotsHttp, statusHttp}));
    }

    private static SecurityCollection createSecurityCollection(String pattern, String ... otherPatterns) {
        SecurityCollection collection = new SecurityCollection();
        collection.addPattern(pattern);
        Arrays.stream(otherPatterns).forEach(arg_0 -> ((SecurityCollection)collection).addPattern(arg_0));
        return collection;
    }

    private static SecurityConstraint createSecurityConstraint(String userConstraint, SecurityCollection ... collections) {
        SecurityConstraint constraint = new SecurityConstraint();
        Arrays.stream(collections).forEach(arg_0 -> ((SecurityConstraint)constraint).addCollection(arg_0));
        constraint.setUserConstraint(userConstraint);
        return constraint;
    }

    public boolean isRequireSsl() {
        return this.requireSsl;
    }

    public void setRequireSsl(boolean requireSsl) {
        this.requireSsl = requireSsl;
    }
}

