/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.web;

import com.atlassian.bitbucket.internal.boot.web.CommonConnectorProperties;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import org.apache.catalina.connector.Connector;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.ResourceUtils;

public class ConnectorProperties
extends CommonConnectorProperties {
    private final int connectorNumber;
    @NestedConfigurationProperty
    private final Compression compression;
    @NestedConfigurationProperty
    private final Ssl ssl;
    private InetAddress address;
    private Integer connectionTimeout;
    private int maxHttpHeaderSize;
    private int maxHttpPostSize;
    private Integer port;

    public ConnectorProperties(int connectorNumber) {
        super("server.additional-connector." + connectorNumber);
        this.connectorNumber = connectorNumber;
        this.compression = new Compression();
        this.ssl = new Ssl();
        this.ssl.setEnabled(false);
    }

    public void customize(Connector connector) {
        AbstractProtocol protocol;
        ProtocolHandler protocolHandler;
        super.customize(connector);
        connector.setPort(this.port.intValue());
        if (this.maxHttpPostSize > 0) {
            connector.setMaxPostSize(this.maxHttpPostSize);
        }
        if ((protocolHandler = connector.getProtocolHandler()) instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)protocolHandler;
            if (this.address != null) {
                protocol.setAddress(this.address);
            }
            if (this.connectionTimeout != null) {
                protocol.setConnectionTimeout(this.connectionTimeout.intValue());
            }
        }
        if (protocolHandler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)protocolHandler;
            if (this.compression.getEnabled()) {
                this.configureCompression((AbstractHttp11Protocol)protocol);
            }
            if (this.maxHttpHeaderSize > 0) {
                protocol.setMaxHttpHeaderSize(this.maxHttpHeaderSize);
            }
        }
        if (this.ssl.isEnabled() && protocolHandler instanceof AbstractHttp11JsseProtocol) {
            connector.setScheme("https");
            connector.setSecure(true);
            protocol = (AbstractHttp11JsseProtocol)protocolHandler;
            this.configureSsl((AbstractHttp11JsseProtocol)protocol);
            this.configureSslKeyStore((AbstractHttp11JsseProtocol)protocol);
            this.configureSslTrustStore((AbstractHttp11JsseProtocol)protocol);
        }
    }

    public String toString() {
        return "AdditionalConnector[" + this.connectorNumber + ": " + this.port + (this.ssl.isEnabled() ? " (SSL)" : "") + "]";
    }

    private void configureCompression(AbstractHttp11Protocol<?> protocol) {
        protocol.setCompressableMimeType(org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])this.compression.getMimeTypes()));
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.compression.getMinResponseSize());
        Object[] excludedUserAgents = this.compression.getExcludedUserAgents();
        if (excludedUserAgents != null && excludedUserAgents.length > 0) {
            protocol.setNoCompressionUserAgents(org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])excludedUserAgents));
        }
    }

    private void configureSsl(AbstractHttp11JsseProtocol<?> protocol) {
        protocol.setSSLEnabled(true);
        protocol.setCiphers(StringUtils.trimToNull((String)org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])this.ssl.getCiphers())));
        protocol.setKeyAlias(this.ssl.getKeyAlias());
        protocol.setKeyPass(this.ssl.getKeyPassword());
        protocol.setSslProtocol(this.ssl.getProtocol());
        Ssl.ClientAuth clientAuth = this.ssl.getClientAuth();
        if (clientAuth == Ssl.ClientAuth.NEED) {
            protocol.setClientAuth("true");
        } else if (clientAuth == Ssl.ClientAuth.WANT) {
            protocol.setClientAuth("want");
        }
        String enabledProtocols = org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])this.ssl.getEnabledProtocols());
        if (!enabledProtocols.isEmpty()) {
            for (SSLHostConfig config : protocol.findSslHostConfigs()) {
                config.setProtocols(enabledProtocols);
            }
        }
    }

    private void configureSslKeyStore(AbstractHttp11JsseProtocol<?> protocol) {
        try {
            protocol.setKeystoreFile(ResourceUtils.getURL((String)this.ssl.getKeyStore()).toString());
        }
        catch (FileNotFoundException e) {
            throw new EmbeddedServletContainerException("\"" + this.getPrefix() + ".ssl.key-store=" + this.ssl.getKeyStore() + "\" references a path which does not exist", (Throwable)e);
        }
        protocol.setKeystorePass(this.ssl.getKeyStorePassword());
        protocol.setKeystoreProvider(this.ssl.getKeyStoreProvider());
        protocol.setKeystoreType(this.ssl.getKeyStoreType());
    }

    private void configureSslTrustStore(AbstractHttp11JsseProtocol<?> protocol) {
        if (this.ssl.getTrustStore() != null) {
            try {
                protocol.setTruststoreFile(ResourceUtils.getURL((String)this.ssl.getTrustStore()).toString());
            }
            catch (FileNotFoundException e) {
                throw new EmbeddedServletContainerException("\"" + this.getPrefix() + ".ssl.trust-store=" + this.ssl.getTrustStore() + "\" references a path which does not exist", (Throwable)e);
            }
            protocol.setTruststorePass(this.ssl.getTrustStorePassword());
            protocol.setTruststoreProvider(this.ssl.getTrustStoreProvider());
            protocol.setTruststoreType(this.ssl.getTrustStoreType());
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public int getMaxHttpPostSize() {
        return this.maxHttpPostSize;
    }

    public Integer getPort() {
        return this.port;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setMaxHttpPostSize(int maxHttpPostSize) {
        this.maxHttpPostSize = maxHttpPostSize;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

