import Urls from 'bitbucket/internal/spi/urls';

class MockUrls extends Urls {

    fileChanges(repository, commitRange) {
        return 'http://example.com/' + repository.slug + '/changes';
    }

    avatarUrl(person, size) {
        return 'http://example.com/' + person.name + '/avatar?size=' + size;
    }

    user(_user) {
        return 'http://example.com/' + _user.name;
    }

    pullRequest(_pullRequest) {
        return 'http://example.com/' + _pullRequest.id;
    }

    createPullRequest(repository) {
        return 'http://example.com/' + repository.slug + '/create-pull-request';
    }

    allPullRequests(repository) {
        return 'http://example.com/' + repository.slug + '/all-pull-requests';
    }

    help(key) {
        return 'http://example.com/help/' + key;
    }
}

export default new MockUrls();