define(
    'bitbucket/internal/bbui/search/internal/search-data-provider',
    ["exports", "module", "bitbucket/internal/impl/data-provider/paged", "../../search-common/search-entities", "../../search-common/search-request", "../../search-common/transformer"],
    function (exports, module, _bitbucketInternalImplDataProviderPaged, _searchCommonSearchEntities, _searchCommonSearchRequest, _searchCommonTransformer) {
        "use strict";

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _PagedDataProviderSPI2 = _interopRequireDefault(_bitbucketInternalImplDataProviderPaged);

        var _SearchEntities = _interopRequireDefault(_searchCommonSearchEntities);

        var SearchDataProvider = (function (_PagedDataProviderSPI) {
            _inherits(SearchDataProvider, _PagedDataProviderSPI);

            function SearchDataProvider(options, initialData) {
                _classCallCheck(this, SearchDataProvider);

                _get(Object.getPrototypeOf(SearchDataProvider.prototype), "constructor", this).call(this, options, initialData);
            }

            _createClass(SearchDataProvider, [{
                key: "_fetch",
                value: function _fetch(searchRequest) {
                    return this.options.search(searchRequest);
                }
            }, {
                key: "_transform",
                value: function _transform(result) {
                    var _this = this;

                    return result[this.options.type].values.map(function (value) {
                        if (_this.options.type === _SearchEntities["default"].CODE) {
                            return (0, _searchCommonTransformer.transformCodeResult)(value);
                        }
                        console.warn("Unknown result type " + _this.options.type + " in dataProvider transform");
                    });
                }
            }, {
                key: "_validate",
                value: function _validate() {
                    return true;
                }
            }, {
                key: "_fetchNext",
                value: function _fetchNext(lastResponseData) {
                    var searchRequest = undefined;

                    if (lastResponseData) {
                        searchRequest = (0, _searchCommonSearchRequest.nextSearchFor)(this.options.query, this.options.type, this.options.limits, lastResponseData);
                    } else {
                        searchRequest = (0, _searchCommonSearchRequest.searchFor)(this.options.query, this.options.limits);
                    }
                    return this._fetch(searchRequest);
                }
            }, {
                key: "_reachedEnd",
                value: function _reachedEnd(lastResponseData) {
                    return lastResponseData[this.options.type].isLastPage;
                }
            }]);

            return SearchDataProvider;
        })(_PagedDataProviderSPI2["default"]);

        module.exports = SearchDataProvider;
    }
);