define(
    'bitbucket/internal/bbui/scroll-handler',
    ['exports', 'module', 'jquery', 'react'],
    function (exports, module, _jquery, _react) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _$ = _interopRequireDefault(_jquery);

        var _React = _interopRequireDefault(_react);

        var docEl = window.document.documentElement;

        var ScrollHandler = (function (_React$Component) {
            _inherits(ScrollHandler, _React$Component);

            function ScrollHandler() {
                _classCallCheck(this, ScrollHandler);

                _get(Object.getPrototypeOf(ScrollHandler.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(ScrollHandler, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    this.updateListeners(null, this.props.scrollElement);
                }
            }, {
                key: 'componentDidUpdate',
                value: function componentDidUpdate(previousProps) {
                    this.updateListeners(previousProps.scrollElement, this.props.scrollElement);
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    this.updateListeners(this.props.scrollElement, null);
                }
            }, {
                key: 'scrollCallback',
                value: function scrollCallback(scrollElement) {
                    if (this.props.suspend) {
                        return;
                    }

                    var $scrollElement = (0, _$['default'])(scrollElement);

                    if (!this._scrollingWindow && $scrollElement.is(':hidden')) {
                        return;
                    }

                    var scrollTop = $scrollElement.scrollTop();
                    var paneHeight = this._getPaneHeight();
                    var contentHeight = this._getContentHeight();
                    var scrollBottom = paneHeight + scrollTop;

                    // In Chrome (not checked since like v12) on Windows at some font sizes (Ctrl +), the scrollPaneHeight is rounded down, but contentHeight is
                    // rounded up (I think). This means there is a 1px difference between them and the event won't fire.
                    var chromeWindowsFontChangeBuffer = 1;

                    var scrolledToBottom = scrollBottom + chromeWindowsFontChangeBuffer >= contentHeight - (this.props.bufferPx | 0);

                    if (scrolledToBottom) {
                        this.props.onScrollToBottom();
                    }
                }
            }, {
                key: 'updateListeners',
                value: function updateListeners(previousScrollElement, currentScrollElement) {
                    previousScrollElement = (0, _$['default'])(previousScrollElement)[0];
                    currentScrollElement = (0, _$['default'])(currentScrollElement)[0];

                    if (previousScrollElement === currentScrollElement) {
                        return;
                    }

                    if (previousScrollElement) {
                        (0, _$['default'])(previousScrollElement).off('scroll', this._scrollCallback);
                        (0, _$['default'])(window).off('resize', this._scrollCallback);
                    }

                    if (currentScrollElement) {
                        this._scrollCallback = this.scrollCallback.bind(this, currentScrollElement);
                        this._scrollingWindow = _$['default'].isWindow(currentScrollElement);
                        this._getPaneHeight = this._scrollingWindow ? function () {
                            return docEl.clientHeight;
                        } : function () {
                            return currentScrollElement.clientHeight;
                        };
                        this._getContentHeight = this._scrollingWindow ? function () {
                            return docEl.scrollHeight;
                        } : function () {
                            return currentScrollElement.scrollHeight;
                        };
                        (0, _$['default'])(currentScrollElement).on('scroll', this._scrollCallback);
                        (0, _$['default'])(window).on('resize', this._scrollCallback);
                    }
                }
            }, {
                key: 'render',
                value: function render() {
                    return this.props.children;
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        bufferPx: _react.PropTypes.number,
                        children: _react.PropTypes.element.isRequired,
                        onScrollToBottom: _react.PropTypes.func.isRequired,
                        scrollElement: _react.PropTypes.oneOfType([_react.PropTypes.node, _react.PropTypes.oneOf([window])]),
                        suspend: _react.PropTypes.bool
                    };
                }
            }, {
                key: 'defaultProps',
                get: function get() {
                    return {
                        scrollElement: window
                    };
                }
            }]);

            return ScrollHandler;
        })(_React['default'].Component);

        module.exports = ScrollHandler;
    }
);