define(
    'bitbucket/internal/bbui/reviewer-avatar',
    ['exports', 'module', 'react', 'lodash', './aui-react/avatar', './models'],
    function (exports, module, _react, _lodash, _auiReactAvatar, _models) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _2 = _interopRequireDefault(_lodash);

        var _Avatar = _interopRequireDefault(_auiReactAvatar);

        var propTypes = {
            avatarSize: _react.PropTypes.string,
            reviewer: _react.PropTypes.shape({
                user: _react.PropTypes.object.isRequired,
                state: _react.PropTypes.oneOf(_2['default'].values(_models.ApprovalState)).isRequired
            }).isRequired,
            withName: _react.PropTypes.bool,
            tooltip: _react.PropTypes.bool,
            nameOnly: _react.PropTypes.bool
        };

        var visibleBadgeCssClass = {
            APPROVED: 'approved',
            NEEDS_WORK: 'needs-work'
        };

        var avatarBadges = [{
            className: visibleBadgeCssClass.APPROVED,
            text: AJS.I18n.getText('bitbucket.component.avatar.badge.approved')
        }, {
            className: visibleBadgeCssClass.NEEDS_WORK,
            text: AJS.I18n.getText('bitbucket.component.avatar.badge.needs.work')
        }];

        function reviewerTooltip(reviewer, nameOnly) {
            var name = reviewer.user.display_name || reviewer.user.name;
            var displayText = undefined;
            if (nameOnly || !reviewer.state || reviewer.state === _models.ApprovalState.UNAPPROVED) {
                displayText = name;
            } else if (reviewer.state === _models.ApprovalState.APPROVED) {
                displayText = AJS.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.approved', name);
            } else {
                displayText = AJS.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.needs.work', name);
            }
            return displayText;
        }

        var ReviewerAvatar = (function (_Component) {
            _inherits(ReviewerAvatar, _Component);

            function ReviewerAvatar() {
                _classCallCheck(this, ReviewerAvatar);

                _get(Object.getPrototypeOf(ReviewerAvatar.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(ReviewerAvatar, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.reviewer.user.name !== newProps.reviewer.user.name || this.props.reviewer.state !== newProps.reviewer.state || this.props.avatarSize !== newProps.avatarSize || Boolean(this.props.nameOnly) !== Boolean(newProps.nameOnly) || Boolean(this.props.tooltip) !== Boolean(newProps.tooltip) || Boolean(this.props.withName) !== Boolean(newProps.withName);
                }
            }, {
                key: 'render',
                value: function render() {
                    var props = this.props;
                    return _React['default'].createElement(_Avatar['default'], {
                        person: props.reviewer.user,
                        size: props.avatarSize,
                        badges: avatarBadges,
                        tooltipText: reviewerTooltip(props.reviewer, props.nameOnly),
                        visibleBadge: props.reviewer.state ? visibleBadgeCssClass[props.reviewer.state] : '',
                        withName: props.withName,
                        tooltip: props.tooltip
                    });
                }
            }]);

            return ReviewerAvatar;
        })(_react.Component);

        ReviewerAvatar.propTypes = propTypes;
        module.exports = ReviewerAvatar;
    }
);