define(
    'bitbucket/internal/bbui/pull-request-table/components/web-section',
    ['exports', 'module', 'react', 'bitbucket/internal/impl/web-fragments', '../../utils/pull-request-unique-id'],
    function (exports, module, _react, _bitbucketInternalImplWebFragments, _utilsPullRequestUniqueId) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _webFragments = _interopRequireDefault(_bitbucketInternalImplWebFragments);

        var _prUniqueId = _interopRequireDefault(_utilsPullRequestUniqueId);

        var beforeSections = _webFragments['default'].getWebSections('bitbucket.pull-request.table-column.before');
        var afterSections = _webFragments['default'].getWebSections('bitbucket.pull-request.table-column.after');

        var WebSectionHeader = function WebSectionHeader(props) {
            var webSection = props.webSection;
            return _React['default'].createElement(
                'th',
                {
                    className: webSection.key + " web-section-column",
                    title: webSection.text,
                    scope: 'col'
                },
                webSection.text
            );
        };

        WebSectionHeader.propTypes = {
            webSection: _react.PropTypes.object.isRequired
        };

        var WebSectionCell = (function (_Component) {
            _inherits(WebSectionCell, _Component);

            function WebSectionCell() {
                _classCallCheck(this, WebSectionCell);

                _get(Object.getPrototypeOf(WebSectionCell.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(WebSectionCell, [{
                key: 'shouldComponentUpdate',

                // We don't want to regrab the web panels for existing rows every time the table rerenders as this would cause them to needlessly
                // redo their work. So we only regrab them when the props actually change. This component is used with a React key={} prop,
                // and in theory each row should only render once ever.
                value: function shouldComponentUpdate(newProps) {
                    return (0, _prUniqueId['default'])(newProps.pullRequest) !== (0, _prUniqueId['default'])(this.props.pullRequest) || newProps.webSection.key !== this.props.webSection.key || newProps.where !== this.props.where;
                }
            }, {
                key: 'render',
                value: function render() {
                    var webSection = this.props.webSection;
                    var pullRequest = this.props.pullRequest;
                    var location = 'bitbucket.pull-request.table-column.' + this.props.where + '/' + webSection.key;
                    return _React['default'].createElement('td', {
                        className: webSection.key + "-value web-section-column",
                        dangerouslySetInnerHTML: {
                            __html: _webFragments['default'].getWebPanels(location, { pullRequest: pullRequest }).map(function (p) {
                                return p.html;
                            }).join('')
                        }
                    });
                }
            }]);

            return WebSectionCell;
        })(_react.Component);

        WebSectionCell.propTypes = {
            pullRequest: _react.PropTypes.object.isRequired,
            webSection: _react.PropTypes.object.isRequired,
            where: _react.PropTypes.string.isRequired
        };

        module.exports = {
            afterSections: afterSections,
            beforeSections: beforeSections,
            WebSectionHeader: WebSectionHeader,
            WebSectionCell: WebSectionCell
        };
    }
);