define(
    'bitbucket/internal/bbui/pull-request-table/components/count-cell',
    ['exports', 'module', 'react', 'classnames'],
    function (exports, module, _react, _classnames) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var UNCAPPED_MAX = 99;

        function cappedInt(n) {
            return n > UNCAPPED_MAX ? UNCAPPED_MAX + '+' : n + '';
        }

        var propTypes = {
            count: _react.PropTypes.number.isRequired,
            icon: _react.PropTypes.node.isRequired,
            tooltip: _react.PropTypes.string.isRequired,
            className: _react.PropTypes.string
        };

        var CountCell = function CountCell(props) {
            return _React['default'].createElement(
                'td',
                { className: (0, _classNames['default'])('count-column-value', props.className) },
                props.count > 0 && _React['default'].createElement(
                    'span',
                    { title: props.tooltip },
                    props.icon,
                    _React['default'].createElement(
                        'span',
                        null,
                        ' '
                    ),
                    _React['default'].createElement(
                        'span',
                        { className: 'count' },
                        cappedInt(props.count)
                    )
                )
            );
        };

        CountCell.Header = function () {
            return _React['default'].createElement('th', { className: 'count-column' });
        };

        CountCell.propTypes = propTypes;

        module.exports = CountCell;
    }
);