define(
    'bitbucket/internal/bbui/pull-request-header/components/merge-instructions',
    ['exports', 'module', 'react', 'bitbucket/internal/impl/urls', '../../aui-react/icon', '../../codeblock'],
    function (exports, module, _react, _bitbucketInternalImplUrls, _auiReactIcon, _codeblock) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var _Icon = _interopRequireDefault(_auiReactIcon);

        var _Codeblock = _interopRequireDefault(_codeblock);

        var Stability = {
            STABLE: 'stable',
            UNSTABLE: 'unstable'
        };

        var MergeInstructions = (function (_Component) {
            _inherits(MergeInstructions, _Component);

            _createClass(MergeInstructions, null, [{
                key: 'propTypes',
                get: function get() {
                    return {
                        stability: _react.PropTypes.oneOf(Object.keys(Stability).map(function (k) {
                            return Stability[k];
                        })),
                        isAutoMergeConflict: _react.PropTypes.bool,
                        pullRequest: _react.PropTypes.object.isRequired
                    };
                }
            }, {
                key: 'defaultProps',
                get: function get() {
                    return {
                        stability: Stability.STABLE
                    };
                }
            }]);

            function MergeInstructions() {
                _classCallCheck(this, MergeInstructions);

                for (var _len = arguments.length, props = Array(_len), _key = 0; _key < _len; _key++) {
                    props[_key] = arguments[_key];
                }

                _get(Object.getPrototypeOf(MergeInstructions.prototype), 'constructor', this).apply(this, props);
                var sourceRepo = this.props.pullRequest.from_ref.repository;
                var targetRepo = this.props.pullRequest.to_ref.repository;
                var sourceRemote = null;
                var targetRemote = null;

                if (sourceRepo.id !== targetRepo.id) {
                    sourceRemote = _urls['default'].remote(sourceRepo);
                    targetRemote = _urls['default'].remote(targetRepo);
                }

                this.refDetails = {
                    sourceBranch: this.props.pullRequest.from_ref.display_id,
                    targetBranch: this.props.pullRequest.to_ref.display_id,
                    sourceRemote: sourceRemote,
                    targetRemote: targetRemote
                };
            }

            /*
            
            
             /**
             * @param sourceBranch
             * @param targetBranch
             /
            {template .autoMergeConflictInstructions private="true"}
            <h3>
                {call aui.icons.icon}
                {param icon: 'warning' /}
                {param useIconFont: true /}
                {/call}
                {getText('bitbucket.component.pull.request.automerge.conflict.title')}
            </h3>
            <p>
            {getText('bitbucket.component.pull.request.automerge.help.introduction')}
            </p>
            
            {call bitbucket.internal.feature.pullRequest.mergeStepsForStableSourceBranch}
            {param sourceBranch: $sourceBranch /}
            {param targetBranch: $targetBranch /}
            {/call}
            {/template}
            
             /**
             * @param sourceBranch
             * @param targetBranch
             * @param? sourceRemote
             * @param? targetRemote
             /
            {template .mergeInstructionsForStableSourceBranch}
            <h3>
                {call aui.icons.icon}
                {param icon: 'warning' /}
                {param useIconFont: true /}
                {/call}
                {getText('bitbucket.component.pull.request.merge.conflict.title')}
            </h3>
            <p>
            {getText('bitbucket.component.pull.request.merge.help.introduction')}
            </p>
            
            {call .mergeStepsForStableSourceBranch}
            {param sourceBranch: $sourceBranch /}
            {param targetBranch: $targetBranch /}
            {param sourceRemote: $sourceRemote /}
            {param targetRemote: $targetRemote /}
            {/call}
            {/template}
            
            /**
             * @param sourceBranch
             * @param targetBranch
             * @param? sourceRemote
             * @param? targetRemote
             /
            {template .mergeInstructionsForUnstableSourceBranch}
            <h3>
                {call aui.icons.icon}
                {param icon: 'warning' /}
                {param useIconFont: true /}
                {/call}
                {getText('bitbucket.component.pull.request.merge.conflict.title')}
            </h3>
            <p>
                {getText('bitbucket.component.pull.request.merge.help.introduction')}
            </p>
            
            {call .mergeStepsForUnstableSourceBranch}
            {param sourceBranch: $sourceBranch /}
            {param targetBranch: $targetBranch /}
            {param sourceRemote: $sourceRemote /}
            {param targetRemote: $targetRemote /}
            {/call}
            {/template}
            
            /**
             * Provides merge instructions for feature/x --> master scenarios where the target branch can be merged into the source
             * branch to resolve the conflicts.
             *
             * @param sourceBranch
             * @param targetBranch
             * @param? sourceRemote
             * @param? targetRemote
             /
            {template .mergeStepsForUnstableSourceBranch}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step1')}</strong>{sp}
                {if $targetRemote}
                {getText('bitbucket.component.pull.request.merge.help.step1.crossrepo.text')}
                {else}
                {getText('bitbucket.component.pull.request.merge.help.step1.samerepo.text')}
                {/if}
            </p>
            {call bitbucket.internal.widget.codeBlock}
            {param content}
            git fetch {$targetRemote ? $targetRemote : 'origin'} {$targetBranch}{\n}
            {/param}
            {param instructionBlock: true /}
            {/call}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step2')}</strong>{sp}
                {getText('bitbucket.component.pull.request.merge.help.step2.text')}
            </p>
            {call bitbucket.internal.widget.codeBlock}
            {param content}
            git checkout {$sourceBranch} {\n}
            git merge FETCH_HEAD
            {/param}
            {param instructionBlock: true /}
            {/call}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step3')}</strong>{sp}
                {getText('bitbucket.component.pull.request.merge.help.step3.text')}
            </p>
            {call bitbucket.internal.widget.codeBlock}
            {param content}
            git commit{\n}
            git push {$sourceRemote ? $sourceRemote : 'origin'} HEAD
            {/param}
            {param instructionBlock: true /}
            {/call}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step4')}</strong>{sp}
                {getText('bitbucket.component.pull.request.merge.help.step4.text')}
            </p>
            {/template}
            
            /**
             * Provides merge instructions for release/x --> master scenarios where the target branch cannot be merged into the
             * source branch to resolve the conflicts.
             *
             * @param sourceBranch
             * @param targetBranch
             * @param? sourceRemote
             * @param? targetRemote
             /
            {template .mergeStepsForStableSourceBranch}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step1')}</strong>{sp}
            
                {if $targetRemote}
                {getText('bitbucket.component.pull.request.merge.fetch.source.branch.crossrepo')}
                {else}
                {getText('bitbucket.component.pull.request.merge.fetch.source.branch.samerepo')}
                {/if}
            </p>
            {call bitbucket.internal.widget.codeBlock}
            {param content}
            git fetch {$sourceRemote ? $sourceRemote : 'origin'} {$sourceBranch}{\n}
            {/param}
            {param instructionBlock: true /}
            {/call}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step2')}</strong>{sp}
                {getText('bitbucket.component.pull.request.merge.source.into.target.resolve.conflicts')}
            </p>
            {call bitbucket.internal.widget.codeBlock}
            {param content}
            git checkout {$targetBranch} {\n}
            git merge FETCH_HEAD
            {/param}
            {param instructionBlock: true /}
            {/call}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step3')}</strong>{sp}
                {getText('bitbucket.component.pull.request.merge.help.step3.text')}
            </p>
            {call bitbucket.internal.widget.codeBlock}
            {param content}
            git commit{\n}
            git push {$targetRemote ? $targetRemote : 'origin'} HEAD
            {/param}
            {param instructionBlock: true /}
            {/call}
            <p>
                <strong>{getText('bitbucket.component.pull.request.merge.help.step4')}</strong>{sp}
                {getText('bitbucket.component.pull.request.merge.merged.remotely')}
            </p>
            {/template}
             */

            _createClass(MergeInstructions, [{
                key: 'mergeSteps',
                value: function mergeSteps() {
                    // Stable source branch means we fetch source first and then target, and then merge FETCH_HEAD in to target
                    // (and thus remotely merging the pull request). This is also the  approach for automerge conflicts.
                    if (this.props.stability === Stability.STABLE || this.props.isAutoMergeConflict) {
                        return _React['default'].createElement(
                            'div',
                            null,
                            _React['default'].createElement(
                                'p',
                                null,
                                _React['default'].createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1'),
                                    ' '
                                ),
                                this.refDetails.targetRemote ? AJS.I18n.getText('bitbucket.component.pull.request.merge.fetch.source.branch.crossrepo') : AJS.I18n.getText('bitbucket.component.pull.request.merge.fetch.source.branch.samerepo')
                            ),
                            _React['default'].createElement(
                                _Codeblock['default'],
                                { instructionBlock: true },
                                'git fetch ',
                                this.refDetails.sourceRemote ? this.refDetails.sourceRemote : 'origin',
                                ' ',
                                this.refDetails.sourceBranch
                            ),
                            _React['default'].createElement(
                                'p',
                                null,
                                _React['default'].createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step2'),
                                    ' '
                                ),
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.source.into.target.resolve.conflicts')
                            ),
                            _React['default'].createElement(
                                _Codeblock['default'],
                                { instructionBlock: true },
                                _React['default'].createElement(
                                    'line',
                                    null,
                                    'git checkout ',
                                    this.refDetails.targetBranch
                                ),
                                _React['default'].createElement(
                                    'line',
                                    null,
                                    'git merge FETCH_HEAD'
                                )
                            ),
                            _React['default'].createElement(
                                'p',
                                null,
                                _React['default'].createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3'),
                                    ' '
                                ),
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3.text')
                            ),
                            _React['default'].createElement(
                                _Codeblock['default'],
                                { instructionBlock: true },
                                _React['default'].createElement(
                                    'line',
                                    null,
                                    'git commit'
                                ),
                                _React['default'].createElement(
                                    'line',
                                    null,
                                    'git push ',
                                    this.refDetails.targetRemote ? this.refDetails.targetRemote : 'origin',
                                    ' HEAD'
                                )
                            ),
                            _React['default'].createElement(
                                'p',
                                null,
                                _React['default'].createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step4'),
                                    ' '
                                ),
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.merged.remotely')
                            )
                        );
                    }
                    // Unstable source branch means we fetch target first and then source, and then merge FETCH_HEAD in to source
                    return _React['default'].createElement(
                        'div',
                        null,
                        _React['default'].createElement(
                            'p',
                            null,
                            _React['default'].createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1'),
                                ' '
                            ),
                            this.refDetails.targetRemote ? AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1.crossrepo.text') : AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1.samerepo.text')
                        ),
                        _React['default'].createElement(
                            _Codeblock['default'],
                            { instructionBlock: true },
                            'git fetch ',
                            this.refDetails.targetRemote ? this.refDetails.targetRemote : 'origin',
                            ' ',
                            this.refDetails.targetBranch
                        ),
                        _React['default'].createElement(
                            'p',
                            null,
                            _React['default'].createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step2'),
                                ' '
                            ),
                            AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step2.text')
                        ),
                        _React['default'].createElement(
                            _Codeblock['default'],
                            { instructionBlock: true },
                            _React['default'].createElement(
                                'line',
                                null,
                                'git checkout ',
                                this.refDetails.sourceBranch
                            ),
                            _React['default'].createElement(
                                'line',
                                null,
                                'git merge FETCH_HEAD'
                            )
                        ),
                        _React['default'].createElement(
                            'p',
                            null,
                            _React['default'].createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3'),
                                ' '
                            ),
                            AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3.text')
                        ),
                        _React['default'].createElement(
                            _Codeblock['default'],
                            { instructionBlock: true },
                            _React['default'].createElement(
                                'line',
                                null,
                                'git commit'
                            ),
                            _React['default'].createElement(
                                'line',
                                null,
                                'git push ',
                                this.refDetails.sourceRemote ? this.refDetails.sourceRemote : 'origin',
                                ' HEAD'
                            )
                        ),
                        _React['default'].createElement(
                            'p',
                            null,
                            _React['default'].createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step4'),
                                ' '
                            ),
                            AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step4.text')
                        )
                    );
                }
            }, {
                key: 'render',
                value: function render() {
                    var title = AJS.I18n.getText('bitbucket.component.pull.request.merge.conflict.title');
                    var intro = AJS.I18n.getText('bitbucket.component.pull.request.merge.help.introduction');
                    if (this.props.isAutoMergeConflict) {
                        title = AJS.I18n.getText('bitbucket.component.pull.request.automerge.conflict.title');
                        intro = AJS.I18n.getText('bitbucket.component.pull.request.automerge.help.introduction');
                    }

                    return _React['default'].createElement(
                        'div',
                        { className: 'merge-instructions' },
                        _React['default'].createElement(
                            'h3',
                            null,
                            _React['default'].createElement(_Icon['default'], { size: 'small', icon: 'warning' }),
                            title
                        ),
                        _React['default'].createElement(
                            'p',
                            { className: 'intro' },
                            intro
                        ),
                        this.mergeSteps()
                    );
                }
            }]);

            return MergeInstructions;
        })(_react.Component);

        module.exports = MergeInstructions;
    }
);
/**
 * This component will return the right set of instructions based on the type of
 * branch it is we're dealing with to successfully resolve conflicts.
 *
 * For stable branches the instructions are to merge source in to target and remotely merge the pull request
 * For unstable branches the instructions are to merge target in to source and update the pull request (and merge from the UI)
 */