define(
    'bitbucket/internal/bbui/paged-table',
    ['exports', 'module', 'react', 'classnames', './aui-react/spinner', './scroll-handler'],
    function (exports, module, _react, _classnames, _auiReactSpinner, _scrollHandler) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var _Spinner = _interopRequireDefault(_auiReactSpinner);

        var _ScrollHandler = _interopRequireDefault(_scrollHandler);

        var propTypes = {
            allFetched: _react.PropTypes.bool.isRequired,
            allFetchedMessage: _react.PropTypes.string,
            bufferPx: _ScrollHandler['default'].propTypes.bufferPx,
            className: _react.PropTypes.string,
            focusedIndex: _react.PropTypes.number,
            header: _react.PropTypes.func,
            items: _react.PropTypes.array.isRequired,
            loading: _react.PropTypes.bool.isRequired,
            onMoreItemsRequested: _react.PropTypes.func.isRequired,
            row: _react.PropTypes.func.isRequired,
            scrollElement: _ScrollHandler['default'].propTypes.scrollElement
        };

        var PagedTable = function PagedTable(props) {
            var VISIBLE_PRS = 7;
            var rows = props.row ? props.items.map(function (item, i) {
                return props.row({
                    item: item,
                    focused: props.focusedIndex === i
                });
            }) : null;

            return _React['default'].createElement(
                'div',
                { className: 'paged-table-container' },
                _React['default'].createElement(
                    _ScrollHandler['default'],
                    {
                        bufferPx: props.bufferPx,
                        onScrollToBottom: props.onMoreItemsRequested,
                        scrollElement: props.scrollElement,
                        suspend: props.allFetched || props.loading
                    },
                    _React['default'].createElement(
                        'table',
                        { className: (0, _classNames['default'])("aui paged-table", props.className) },
                        props.header && _React['default'].createElement(
                            'thead',
                            null,
                            props.header()
                        ),
                        _React['default'].createElement(
                            'tbody',
                            null,
                            rows
                        )
                    )
                ),
                props.loading && _React['default'].createElement(_Spinner['default'], null),
                props.allFetched && !props.loading && props.items.length > VISIBLE_PRS && _React['default'].createElement(
                    'div',
                    { className: 'paged-table-message' },
                    props.allFetchedMessage
                )
            );
        };

        PagedTable.propTypes = propTypes;

        module.exports = PagedTable;
    }
);