define(
    'bitbucket/internal/bbui/mirror-clone-selector',
    ['exports', 'module', 'jquery', 'lodash', 'bitbucket/internal/impl/urls', './widget'],
    function (exports, module, _jquery, _lodash, _bitbucketInternalImplUrls, _widget) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        // Required by the soy templates

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        //eslint-disable-line no-unused-vars

        var _Widget2 = _interopRequireDefault(_widget);

        var ELLIPSIS_PADDING = 15;

        var MirroringCloneSelector = (function (_Widget) {
            _inherits(MirroringCloneSelector, _Widget);

            /**
             * @typedef {Object} MinimalMirror
             * @param {String} id       - the mirror's ID
             * @param {String} name     - the mirror's name
             * @param {String} url      - the path to the mirror repo info REST resource
             */

            /**
             * @typedef {Object} MirroredRepository
             * @param {String}              mirrorName  - the name of the mirror
             * @param {String}              id          - the ID of the mirror
             * @param {boolean}             available   - true if the repository is available on the mirror, false otherwise
             * @param {Object}              links       - a map of link type to link
             * @param {Array<NamedLink>}    links.clone - an array of clone urls available on the primary
             */

            /**
             * @typedef {Object} MinimalUpstreamServer
             * @param {String}              mirrorName  - the name
             * @param {Object}              links       - a map of link type to link
             * @param {Array<NamedLink>}    links.clone - an array of clone urls available on the primary
             */

            /**
             * @typedef {Object} NamedLink
             * @param {String} name - the type of link. Usually the protocol, for example: 'HTTP' or 'SSH'
             * @param {String} href - the URL - for this component usually a clone URL.
             */

            /**
             * Turns el into a mirroring clone URL selector.
             * @param {HTMLElement|jQuery}      el                                  - The container element
             * @param {Object}                  options                             - Options for this MirroringCloneSelector
             * @param {MinimalUpstreamServer}   options.primary                     - an object describing the upstream server's configuration
             * @param {String}                  options.cloneProtocol               - the current cloneProtocol.
             * @param {Function}                [options.updateCloneUrl=_.noop] - a function that is called after the clone url has been updated
             * @param {Function}                [options.updatePreferredMirror=_.noop] - a function that is called to update the preferred mirror
             * @param {Function<Promise<MinimalMirror>>} [options.getMirrors] - a function that returns a promise to an array of mirror servers to query.
             * @param {String}                  [options.preferredMirrorId=null]  - the ID of the preferred mirror server, or null if none is set
             */

            function MirroringCloneSelector(el, options) {
                _classCallCheck(this, MirroringCloneSelector);

                _get(Object.getPrototypeOf(MirroringCloneSelector.prototype), 'constructor', this).call(this, options);
                this.$el = (0, _$['default'])(el);
                this.availableMirrors = [];
                this.clicked = false;
                this.loaded = false;
                this.preferredMirrorId = this.options.preferredMirrorId;
                this.cloneProtocol = this.options.cloneProtocol;
                this.init();
            }

            /**
             * Adds an available mirror to the list
             * @param {MirroredRepository} mirroredRepository - A mirrored repository
             */

            _createClass(MirroringCloneSelector, [{
                key: 'addMirror',
                value: function addMirror(mirroredRepository) {
                    if (mirroredRepository.available) {
                        this.availableMirrors.push(mirroredRepository);
                        var $availableMirrorsList = (0, _$['default'])('#available-mirror-list');
                        var $availableMirrors = $availableMirrorsList.find('li.mirror');
                        var $newMirror = (0, _$['default'])(bitbucket.internal.component.mirroringCloneSelector.mirrorItem({
                            item: mirroredRepository,
                            extraClasses: 'mirror'
                        }));
                        var $contextEl = _2['default'].find($availableMirrors, function (el) {
                            return (0, _$['default'])(el).text() > mirroredRepository.mirrorName;
                        });
                        if ($contextEl) {
                            $newMirror.insertBefore($contextEl);
                        } else {
                            $newMirror.appendTo($availableMirrorsList);
                        }

                        this.$trigger.removeAttr('disabled');

                        if (this.preferredMirrorId === mirroredRepository.id && !this.clicked) {
                            this.selectMirror(mirroredRepository.id);
                        }
                    }
                }

                /**
                 * Extracts the clone URL of the current protocol for the specified mirror
                 * @param {MirroredRepository|MinimalUpstreamServer} value - The Server or Repository to get a clone URL for
                 * @returns {String} the clone URL or an empty string
                 */
            }, {
                key: 'getCloneUrl',
                value: function getCloneUrl(value) {
                    return _2['default'].get(_2['default'].find(value.links.clone, 'name', this.getProtocol()), 'href', '');
                }

                /**
                 * @returns {String} the currently selected protocol
                 */
            }, {
                key: 'getProtocol',
                value: function getProtocol() {
                    return this.cloneProtocol;
                }

                /**
                 * Hides the "clone from" dropdown, if it is showing.
                 */
            }, {
                key: 'hideDropdown',
                value: function hideDropdown() {
                    if (this.$dropdown.is(':visible')) {
                        this.$trigger.trigger('aui-button-invoke');
                    }
                }
            }, {
                key: 'init',
                value: function init() {
                    this.$el.html(bitbucket.internal.component.mirroringCloneSelector.main({ primary: this.options.primary }));
                    this.$trigger = this.$el.find('#available-mirrors-trigger');
                    this.$trigger.on('click', function (e) {
                        return e.preventDefault();
                    });
                    this.initDropdown();
                }

                /**
                 * Initialize any dropdown handlers.
                 */
            }, {
                key: 'initDropdown',
                value: function initDropdown() {
                    var _this = this;

                    this.$dropdown = (0, _$['default'])('#available-mirrors');

                    /**
                     * @this {HTMLElement} the clicked element
                     */
                    this.$dropdown.on('click', '.mirror-item', function (e) {
                        e.preventDefault();
                        _this.selectMirror((0, _$['default'])(e.currentTarget).data('id'));
                        _this._updatePreferredMirror();
                        _this.clicked = true;
                    });
                }

                /**
                 *
                 */
            }, {
                key: 'load',
                value: function load() {
                    var _this2 = this;

                    if (!this.loaded) {
                        this.loaded = true;
                        this.options.getMirrors().done(function (mirrors) {

                            var preferred = [];

                            if (_this2.preferredMirrorId) {
                                preferred = _2['default'].remove(mirrors, function (item) {
                                    return item.id === _this2.preferredMirrorId;
                                });
                            }

                            preferred.forEach(function (mirror) {
                                _this2.loadMirror(mirror);
                            });

                            mirrors.forEach(function (mirror) {
                                _this2.loadMirror(mirror);
                            });
                        });
                    }
                }

                /**
                 * Calls the mirror's REST API to check if it is available and retrieve clone URLs
                 * @param {MinimalMirror} mirror - The Mirror to load clone URLs for if it is available
                 */
            }, {
                key: 'loadMirror',
                value: function loadMirror(mirror) {
                    var _this3 = this;

                    _$['default'].ajax({
                        type: 'GET',
                        contentType: 'application/json',
                        url: mirror.url,
                        dataType: 'json'
                    }).done(function (availableMirror) {
                        availableMirror.id = mirror.id;
                        _this3.addMirror(availableMirror);
                    });
                }

                /**
                 * Selects the mirror with the specified ID
                 * @param {string} mirrorId - The mirror's ID
                 */
            }, {
                key: 'selectMirror',
                value: function selectMirror(mirrorId) {
                    this.currentMirrorId = mirrorId;
                    this.updateCloneUrl();
                }

                /**
                 * Show or hide the set push url instructions
                 * @param {boolean} visible - Should the instructions be visible
                 */
            }, {
                key: 'showSetPushUpstream',
                value: function showSetPushUpstream(visible) {
                    var $container = (0, _$['default'])('#update-push-url-container');
                    if (visible) {
                        (0, _$['default'])('#update-push-url-input').val('git remote set-url --push origin ' + this.getCloneUrl(this.options.primary));
                        $container.removeClass('hidden');
                    } else {
                        $container.addClass('hidden');
                    }
                }

                /**
                 * Updates the current clone protocol to the value supplied.
                 * This should be called by the component's host whenever the selected protocol changes.
                 * @param {String} protocol - the protocol to update the state to, for example 'ssh' or 'http'
                 * @returns {String} protocol
                 */
            }, {
                key: 'updateCloneProtocol',
                value: function updateCloneProtocol(protocol) {
                    this.cloneProtocol = protocol;
                    this.updateCloneUrl();
                    return protocol;
                }

                /**
                 * Sets the clone URL.
                 */
            }, {
                key: 'updateCloneUrl',
                value: function updateCloneUrl() {
                    var currentMirror = undefined;
                    if (this.currentMirrorId) {
                        currentMirror = _2['default'].find(this.availableMirrors, 'id', this.currentMirrorId);
                        this.showSetPushUpstream(true);
                    } else {
                        currentMirror = this.options.primary;
                        this.showSetPushUpstream(false);
                    }
                    this.currentMirrorId = currentMirror.id;
                    this.$trigger.text(currentMirror.mirrorName);
                    // We need to set the maxWidth because: the label is i18n and can vary in width and the $trigger's width
                    // is controlled by AUI.
                    this.$trigger.css('maxWidth', this.$el.width() - this.$el.find('#clone-from-label').width() - ELLIPSIS_PADDING);

                    this.options.updateCloneUrl(this.getProtocol(), this.getCloneUrl(currentMirror));
                }
            }, {
                key: 'show',
                value: function show() {
                    this.$el.show();
                }
            }, {
                key: 'hide',
                value: function hide() {
                    this.hideDropdown();
                    this.$el.hide();
                }
            }, {
                key: '_updatePreferredMirror',
                value: function _updatePreferredMirror() {
                    this.preferredMirrorId = this.currentMirrorId;
                    this.options.updatePreferredMirror(this.preferredMirrorId);
                }
            }]);

            return MirroringCloneSelector;
        })(_Widget2['default']);

        module.exports = MirroringCloneSelector;

        MirroringCloneSelector.defaults = {
            cloneProtocol: 'http',
            preferredMirrorId: null,
            updateCloneUrl: _2['default'].noop,
            updatePreferredMirror: _2['default'].noop,
            getMirrors: function getMirrors() {
                return _$['default'].when([]);
            }
        };
    }
);