define("bitbucket/internal/widget/image-explorer",["aui","fd-slider","jquery","lodash"],function(k,p,l,g){function a(b,a){this.init.apply(this,arguments)}a.scaleModes={fill:"fill",contain:"contain",containAndFill:"containAndFill"};a.zoomModes={localZoom:"localZoom",imageZoom:"imageZoom"};a.maskShapes={CIRCLE:"circle",SQUARE:"square",ROUNDED_SQUARE:"rounded-square"};a.prototype.defaults={initialScaleMode:a.scaleModes.containAndFill,zoomMode:a.zoomModes.localZoom,emptyClass:"empty",scaleMax:1};a.prototype.init=
function(b,a){this.$container=b;this.$imageView=this.$container.find(".image-explorer-image-view");this.$sourceImage=this.$container.find(".image-explorer-source");this.$mask=this.$container.find(".image-explorer-mask");this.$dragDelegate=this.$container.find(".image-explorer-drag-delegate");this.$scaleSlider=this.$container.find(".image-explorer-scale-slider");this.options=l.extend({},this.defaults,a);this.imageProperties={};g.bindAll(this,"getImageSrc","setImageSrc","initImage","initDragDelegate",
"initScaleSlider","setInitialScale","getFillScale","getContainedScale","getCircularContainedScale","sliderValToScale","scaleToSliderVal","updateImageScale","resetImagePosition","resetScaleSlider","toggleEmpty","get$ImageView","get$SourceImage","get$Mask","get$DragDelegate","getMaskedImageProperties","showError","clearError","hasValidImage","_resetFromError","_removeError");this.toggleEmpty(!0);this.$sourceImage[0].naturalWidth&&(this.toggleEmpty(!1),this.initImage({target:this.$sourceImage[0]}));
this.$sourceImage.on("load",this.initImage);this.initDragDelegate();this.initScaleSlider()};a.prototype.getImageSrc=function(){return this.$sourceImage?this.$sourceImage.attr("src"):void 0};a.prototype.setImageSrc=function(b){this.$sourceImage&&(this.$sourceImage.attr("src",""),b?this.$sourceImage.attr("src",b):this.toggleEmpty(!0))};a.prototype.initImage=function(b){b=b.target;this.imageProperties.naturalWidth=b.naturalWidth;this.imageProperties.naturalHeight=b.naturalHeight;this._removeError();
this.toggleEmpty(!1);this.setInitialScale()};a.prototype.initDragDelegate=function(){var b;this.$dragDelegate.draggable({start:g.bind(function(){b=this.$sourceImage.offset()},this),drag:g.bind(function(a,c){this.$sourceImage.offset({top:b.top+c.position.top-c.originalPosition.top,left:b.left+c.position.left-c.originalPosition.left})},this),revert:!0,revertDuration:0})};a.prototype.initScaleSlider=function(){this.$scaleSlider.on("change input",g.bind(function(b){b=this.sliderValToScale(b.target.value);
this.updateImageScale(b)},this))};a.prototype.setInitialScale=function(){var b=this.$mask.width(),e=this.$mask.height(),c=this.imageProperties.naturalWidth,d=this.imageProperties.naturalHeight,f=1;this.minScale=1;switch(this.options.initialScaleMode){case a.scaleModes.fill:this.minScale=f=this.getFillScale(c,d,b,e);break;case a.scaleModes.contain:this.$mask.hasClass("circle-mask")?this.minScale=f=this.getCircularContainedScale(c,d,b/2):this.minScale=f=this.getContainedScale(c,d,b,e);break;case a.scaleModes.containAndFill:this.$mask.hasClass("circle-mask")?
this.minScale=this.getCircularContainedScale(c,d,b/2):this.minScale=this.getContainedScale(c,d,b,e),f=this.getFillScale(c,d,b,e)}this.maxScale=Math.max(f,this.options.scaleMax);this.resetScaleSlider(this.scaleToSliderVal(f));this.updateImageScale(f,a.zoomModes.imageZoom);this.resetImagePosition()};a.prototype.getFillScale=function(b,a,c,d){return Math.max(c/b,d/a)};a.prototype.getContainedScale=function(b,a,c,d){return Math.min(c/b,d/a)};a.prototype.getCircularContainedScale=function(b,a,c){a=Math.atan(a/
b);return Math.cos(a)*c*2/b};a.prototype.sliderValToScale=function(b){var a=this.$scaleSlider.attr("max"),c=this.$scaleSlider.attr("min");return this.minScale+b/(a-c)*(this.maxScale-this.minScale)};a.prototype.scaleToSliderVal=function(a){return(a-this.minScale)/(this.maxScale-this.minScale)*(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"))};a.prototype.updateImageScale=function(b,e){var c=Math.round(b*this.imageProperties.naturalWidth),d=Math.round(b*this.imageProperties.naturalHeight),
f,h;e=e||this.options.zoomMode;switch(e){case a.zoomModes.imageZoom:f=-1*c/2;h=-1*d/2;break;case a.zoomModes.localZoom:f=this.$sourceImage.width();var g=this.$sourceImage.height(),k=parseInt(this.$sourceImage.css("margin-left"),10),l=parseInt(this.$sourceImage.css("margin-top"),10);h=this.$sourceImage.position();var m=this.$imageView.width()/2,n=this.$imageView.height()/2,g=(n-h.top-l)/g*d;f=m-h.left-(m-h.left-k)/f*c;h=n-h.top-g}this.$sourceImage.width(c).height(d).css({"margin-left":Math.round(f)+
"px","margin-top":Math.round(h)+"px"})};a.prototype.resetImagePosition=function(){this.$sourceImage.css({top:"50%",left:"50%"})};a.prototype.resetScaleSlider=function(a){this.$scaleSlider.val(a).removeClass("disabled").removeAttr("disabled");a=this.$scaleSlider.attr("id");p._deprecatedUpdateSlider(a)};a.prototype.toggleEmpty=function(a){this.$container.toggleClass(this.options.emptyClass,a)};a.prototype.get$ImageView=function(){return this.$imageView};a.prototype.get$SourceImage=function(){return this.$sourceImage};
a.prototype.get$Mask=function(){return this.$mask};a.prototype.get$DragDelegate=function(){return this.$dragDelegate};a.prototype.getMaskedImageProperties=function(){var a=this.$sourceImage.width()/this.imageProperties.naturalWidth,e=this.$sourceImage.height()/this.imageProperties.naturalHeight,c=this.$mask.position(),d=this.$sourceImage.position();c.top+=parseInt(this.$mask.css("margin-top"),10);c.left+=parseInt(this.$mask.css("margin-left"),10);d.top+=parseInt(this.$sourceImage.css("margin-top"),
10);d.left+=parseInt(this.$sourceImage.css("margin-left"),10);return{maskedAreaImageX:Math.round((c.left-d.left)/a),maskedAreaImageY:Math.round((c.top-d.top)/e),maskedAreaWidth:Math.round(this.$mask.width()/a),maskedAreaHeight:Math.round(this.$mask.height()/e)}};a.prototype.showError=function(a,e){this._removeError();this.toggleEmpty(!0);this.$container.addClass("error");var c=l(aui.message.error({titleContent:k.escapeHtml(a),content:e||"",isCloseable:!0}));c.appendTo(this.$imageView).css({"margin-top":-1*
c.outerHeight()/2});c.on("messageClose",this._resetFromError);k.messages.setup()};a.prototype.clearError=function(){this._removeError();this._resetFromError()};a.prototype.hasValidImage=function(){return!(!this.getImageSrc()||!this.$sourceImage.prop("naturalWidth"))};a.prototype._resetFromError=function(){var a=this.hasValidImage();this.toggleEmpty(!a);this.$container.removeClass("error");g.isFunction(this.options.onErrorReset)&&this.options.onErrorReset(a?this.getImageSrc():void 0)};a.prototype._removeError=
function(){this.$imageView.find(".aui-message-error").remove()};return a});