define('bitbucket/internal/feature/file-content/file-blame/blame-source', [
    'bitbucket/util/navbuilder',
    'bitbucket/util/server',
    'bitbucket/internal/util/property'
], function (
    nav,
    server,
    propertyUtil
) {
    'use strict';

    function BlameSource(fileChange) {
        var blameDataPromise;
        this.get = function() {
            if (!blameDataPromise) {
                blameDataPromise = requestBlame(fileChange);
            }
            return blameDataPromise;
        };

        function requestBlame(fileChange) {
            return propertyUtil.getFromProvider('display.max.source.lines').then(function(capacity) {
                return server.rest({
                    url : nav.currentRepo()
                        .browse()
                        .path(fileChange.path)
                        .at(fileChange.commitRange.untilRevision.id)
                        .build(),
                    data : {
                        blame: true,
                        noContent: true,
                        start: 0,
                        limit: capacity,
                        avatarSize: bitbucket.internal.widget.avatarSizeInPx({ size: 'xsmall' })
                    }
                });
            });
        }
    }

    return BlameSource;
});