define(
    'bitbucket/internal/bbui/pull-request-table/components/reviewers',
    ['exports', 'module', 'react', 'lodash', '../../reviewer-avatar-list'],
    function (exports, module, _react, _lodash, _reviewerAvatarList) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _2 = _interopRequireDefault(_lodash);

        var _ReviewerAvatarList = _interopRequireDefault(_reviewerAvatarList);

        var MAX_OPEN = 3;

        function anyReviewersDifferent(oldReviewers, newReviewers) {
            return oldReviewers.length !== newReviewers.length || _2['default'].zip(oldReviewers, newReviewers).some(function (a, b) {
                return a.name !== b.name || a.state !== b.state;
            });
        }

        var Reviewers = (function (_Component) {
            _inherits(Reviewers, _Component);

            function Reviewers() {
                _classCallCheck(this, Reviewers);

                _get(Object.getPrototypeOf(Reviewers.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(Reviewers, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.pullRequest.id !== newProps.pullRequest.id || anyReviewersDifferent(this.props.pullRequest.reviewers, newProps.pullRequest.reviewers) || this.props.pullRequest.state !== newProps.pullRequest.state;
                }
            }, {
                key: 'render',
                value: function render() {
                    var pullRequest = this.props.pullRequest;

                    return _React['default'].createElement(
                        'td',
                        { className: 'reviewers' },
                        _React['default'].createElement(_ReviewerAvatarList['default'], {
                            avatarSize: 'small',
                            currentUserAsReviewer: this.props.currentUser,
                            currentUserAvatarSize: this.props.currentUserAvatarSize,
                            dialogReviewersAsTooltip: this.props.dialogReviewersAsTooltip,
                            maxOpen: MAX_OPEN,
                            menuId: 'reviewers-' + pullRequest.id,
                            permissionToReview: false,
                            pullRequestIsOpen: pullRequest.state === 'OPEN',
                            reviewers: pullRequest.reviewers
                        })
                    );
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        currentUser: _react.PropTypes.object,
                        currentUserAvatarSize: _react.PropTypes.string,
                        dialogReviewersAsTooltip: _ReviewerAvatarList['default'].propTypes.dialogReviewersAsTooltip,
                        pullRequest: _react.PropTypes.object.isRequired
                    };
                }
            }]);

            return Reviewers;
        })(_react.Component);

        Reviewers.Header = function () {
            return _React['default'].createElement(
                'th',
                { className: 'reviewers', scope: 'col' },
                AJS.I18n.getText('bitbucket.pull.request.table.title.reviewers')
            );
        };

        module.exports = Reviewers;
    }
);