define(
    'bitbucket/internal/bbui/models',
    ['exports', 'module', 'lodash', './json-validation'],
    function (exports, module, _lodash, _jsonValidation) {
        /*eslint camelcase:0 */
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _2 = _interopRequireDefault(_lodash);

        var _validator = _interopRequireDefault(_jsonValidation);

        /**
         * Any person. Could be a user of the application, a committer to a repository, etc.
         *
         * @class Person
         * @property {string?} email_address - email for the user. Usually only appears on the current user
         * @property {string} name - @username for the user
         */
        var person = {
            email_address: 'string?',
            name: 'string'
        };

        /**
         * A user type
         * @enum {string}
         */
        var UserType = {
            NORMAL: 'NORMAL',
            SERVICE: 'SERVICE'
        };

        /**
         * A project type
         * @enum {string}
         */
        var ProjectType = {
            NORMAL: 'NORMAL',
            PERSONAL: 'PERSONAL'
        };

        /**
         * The SCM id
         * @enum {string}
         */
        var scmId = {
            GIT: 'git',
            HG: 'hg'
        };

        /**
         * A person who is a user of this application.
         *
         * Note that the following properties will be used by frontend components directly.
         * In order to satisfy some SPIs, you may need additional properties on your model.
         * For example, Server needs an avatarUrl property to accurately provide avatar urls in
         * bitbucket/internal/urls
         *
         * @class User
         * @extends Person
         * @param {boolean} is_active - whether the user still has an active account
         * @param {string} display_name - the name to show in UI for the user
         * @param {boolean} is_admin - whether the user is an instance-wide admin. Can be used to
         *                            provide extra links/actions that are only available to instance
         *                            admins (e.g., edit other users, etc). Of course checks on the
         *                            backend should stop non-admins from making use of those links
         *                            regardless of this value.
         * @param {UserType} type - is this a real person or service user?
         * @param {string} avatar_url - The URL to the avatar of this user.
         */
        var user = _2['default'].extend({}, person, {
            avatar_url: 'string',
            display_name: 'string',
            is_active: 'boolean',
            is_admin: 'boolean',
            slug: 'string?',
            type: _validator['default'].asEnum('UserType', UserType)
        });

        // Currently (as of 2015-07-07) only Server has the concept of a Project
        var project = {
            id: 'string',
            name: 'string',
            key: 'string',
            description: 'string?',
            type: _validator['default'].asEnum('ProjectType', ProjectType),
            owner: _validator['default'].nullable(user),
            is_public: 'boolean'
        };

        var repository = {
            id: 'string',
            name: 'string',
            slug: 'string',
            is_forkable: 'boolean',
            is_public: 'boolean',
            origin: _validator['default'].nullable(_validator['default'].recurse(function () {
                return repository;
            })),
            scm_id: _validator['default'].asEnum('scmId', scmId)
        };

        /**
         * The type of a ref
         * @enum {string}
         */
        var RefType = {
            TAG: 'tag',
            BRANCH: 'branch',
            COMMIT: 'commit'
        };

        var ref = {
            id: 'string',
            display_id: 'string',
            type: _validator['default'].asEnum('RefType', RefType),
            is_default: 'boolean',
            latest_commit: 'string?',
            repository: _validator['default'].nullable(repository)
        };

        /**
         * Pull request participant's role
         * @enum {string}
         */
        var ParticipantRole = {
            AUTHOR: 'author',
            REVIEWER: 'reviewer',
            PARTICIPANT: 'participant'
        };

        /**
         * Pull request Participant's approval state of the pull request
         * @enum {string}
         */
        var ApprovalState = {
            APPROVED: 'APPROVED',
            NEEDS_WORK: 'NEEDS_WORK',
            UNAPPROVED: 'UNAPPROVED'
        };

        /**
         * User's actions to add/remove themselves from a PR
         * @enum {string}
         */
        var SelfAction = {
            ADD_SELF: 'ADD_SELF',
            REMOVE_SELF: 'REMOVE_SELF'
        };

        /**
         * Pull request state
         * @enum {string}
         */
        var PullRequestState = {
            OPEN: 'OPEN',
            MERGED: 'MERGED',
            DECLINED: 'DECLINED'
        };

        var abstractParticipant = {
            user: user,
            role: _validator['default'].asEnum('Role', ParticipantRole),
            state: _validator['default'].asEnum('ApprovalState', ApprovalState)
        };
        var author = _2['default'].extend({}, abstractParticipant, { role: _validator['default'].strictEqual(ParticipantRole.AUTHOR) });
        var reviewer = _2['default'].extend({}, abstractParticipant, { role: _validator['default'].strictEqual(ParticipantRole.REVIEWER) });
        var participant = _2['default'].extend({}, abstractParticipant, { role: _validator['default'].strictEqual(ParticipantRole.PARTICIPANT) });

        var pull_request = {
            author: author,
            description: 'string?',
            description_as_html: 'string?',
            created_date: 'string', // should be an ISO-8601 time string
            comment_count: 'number',
            from_ref: ref,
            id: 'string?',
            participants: [participant],
            reviewers: [reviewer],
            state: _validator['default'].asEnum('PullRequestState', PullRequestState),
            task_count: 'number',
            title: 'string?',
            titleHtml: 'string?',
            to_ref: ref,
            updated_date: 'string', // should be an ISO-8601 time string
            version: 'number?'
        };

        var comment = {}; // TODO

        var task = {}; // TODO

        // a change between two commits, including file diffs.
        var changeset = {}; // TODO

        // information about a file - e.g. filename, binary vs text, etc.
        var file_metadata = {}; // TODO

        // the source of a text file.
        var file_text = {}; // TODO

        var permission = {
            name: _validator['default'].asEnum('permission', {
                KNOWN_USER: 'KNOWN_USER', // == LICENSED_USER on Server -> any logged-in user
                REPO_READ: 'REPO_READ', // can view the given repo
                REPO_WRITE: 'REPO_WRITE', // can push to the given repo
                REPO_ADMIN: 'REPO_ADMIN', // can administrate the given repo
                SYS_ADMIN: 'SYS_ADMIN' }),
            // on Cloud, I suspect this is just the Bitbucket team.
            project_id: 'string?', // in Server this is a number.
            project_key: 'string?', // the URL identifier for the project
            repository_id: 'string?', // in Server this is a number
            repository_slug: 'string?' };

        // the URL identifier for the repository. If specified, project_key must also be specified.
        module.exports = {

            // Enums
            ApprovalState: ApprovalState,
            ProjectType: ProjectType,
            PullRequestState: PullRequestState,
            RefType: RefType,
            ParticipantRole: ParticipantRole,
            SelfAction: SelfAction,
            scmId: scmId,
            UserRole: ParticipantRole, // deprecated in 1.3.0. Used in Stash. But usage was never released. Please remove in Sep 2015 - no breaking change needed.
            UserType: UserType,

            // Models
            changeset: changeset,
            comment: comment,
            file_metadata: file_metadata,
            file_text: file_text,
            permission: permission,
            person: person,
            project: project,
            pull_request: pull_request,
            ref: ref,
            repository: repository,
            task: task,
            user: user
        };
    }
);