define(
    'bitbucket/internal/bbui/image-differ',
    ['exports', 'module', 'jquery', './image-differ/image-differ', './image-differ/image-differ-toolbar'],
    function (exports, module, _jquery, _imageDiffer, _imageDifferToolbar) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _$ = _interopRequireDefault(_jquery);

        var _Differ = _interopRequireDefault(_imageDiffer);

        var _Toolbar = _interopRequireDefault(_imageDifferToolbar);

        /**
         * @param {jQuery|HtmlElement} container - The container to use for this Image Differ
         * @returns {{on: Function, readyPromise: Promise}}
         */
        function init(container) {
            var $container = (0, _$['default'])(container);
            var toolbar = new _Toolbar['default']((0, _$['default'])(bitbucket.internal.component.imageDiffer.toolbar.main()).prependTo($container));
            var differ = new _Differ['default']($container);

            toolbar.on('modeChanged', function (mode) {
                return differ.setMode(mode.newMode);
            });

            var readyPromise = new _$['default'].Deferred();
            differ.init().done(function (enabledModes) {
                if (toolbar) {
                    toolbar.init(enabledModes);
                }
                readyPromise.resolve({

                    /**
                     * Stop exposing this method when Stash no longer needs to retrigger Image Differ events
                     * @deprecated
                     */
                    on: differ.on.bind(differ),
                    enabledModes: enabledModes,
                    _differ: differ,
                    _toolbar: toolbar,
                    destroy: function destroy() {
                        differ.destroy();
                        differ = null;
                        toolbar.destroy();
                        toolbar = null;
                    }
                });
            });
            return readyPromise;
        }

        module.exports = {
            init: init,
            Differ: _Differ['default'],
            Toolbar: _Toolbar['default']
        };
    }
);